/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.binding;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.ibatis.annotations.Flush;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MapperMethod {
    private final SqlCommand command;
    private final MethodSignature method;

    public MapperMethod(Class<?> mapperInterface, Method method, Configuration config) {
        this.command = new SqlCommand(config, mapperInterface, method);
        this.method = new MethodSignature(config, mapperInterface, method);
    }

    public static Class<?> parseInferredClass(Type genericType) {
        ParameterizedType type;
        Type[] typeArguments;
        Class<?> inferredClass = null;
        if (genericType instanceof ParameterizedType && (typeArguments = (type = (ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            Type typeArgument = typeArguments[0];
            if (typeArgument instanceof ParameterizedType) {
                inferredClass = (Class)((ParameterizedType)typeArgument).getActualTypeArguments()[0];
            } else if (typeArgument instanceof Class) {
                inferredClass = (Class)typeArgument;
            } else {
                String typeName = typeArgument.getTypeName();
                if (typeName.contains(" ")) {
                    typeName = typeName.substring(typeName.lastIndexOf(" ") + 1);
                }
                if (typeName.contains("<")) {
                    typeName = typeName.substring(0, typeName.indexOf("<"));
                }
                try {
                    inferredClass = Class.forName(typeName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (inferredClass == null && genericType instanceof Class) {
            inferredClass = (Class<?>)genericType;
        }
        return inferredClass;
    }

    public Object execute(ReactiveSqlSession sqlSession, Object[] args) {
        Object result;
        switch (this.command.getType()) {
            case INSERT: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.insert(this.command.getName(), param));
                break;
            }
            case UPDATE: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.update(this.command.getName(), param));
                break;
            }
            case DELETE: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.delete(this.command.getName(), param));
                break;
            }
            case SELECT: {
                if (this.method.returnsVoid()) {
                    result = this.executeWithVoid(sqlSession, args).then();
                    break;
                }
                if (this.method.returnsMany()) {
                    result = this.executeForMany(sqlSession, args);
                    break;
                }
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = sqlSession.selectOne(this.command.getName(), param);
                break;
            }
            case FLUSH: {
                throw new UnsupportedOperationException("Unsupported execution command : " + SqlCommandType.FLUSH);
            }
            default: {
                throw new BindingException("Unknown execution method for: " + this.command.getName());
            }
        }
        if (result == null && this.method.getReturnType().isPrimitive() && !this.method.returnsVoid()) {
            throw new BindingException("Mapper method '" + this.command.getName() + " attempted to return null from a method with a primitive return type (" + this.method.getReturnType() + ").");
        }
        return result;
    }

    private Object rowCountResult(Mono<Integer> rowCount) {
        Mono result;
        if (this.method.returnsVoid()) {
            result = rowCount.then();
        } else if (Integer.class.equals(this.method.getReturnInferredType()) || Integer.TYPE.equals(this.method.getReturnInferredType())) {
            result = rowCount.defaultIfEmpty((Object)0);
        } else if (Long.class.equals(this.method.getReturnInferredType()) || Long.TYPE.equals(this.method.getReturnInferredType())) {
            result = rowCount.map(Long::valueOf).defaultIfEmpty((Object)0L);
        } else if (Boolean.class.equals(this.method.getReturnInferredType()) || Boolean.TYPE.equals(this.method.getReturnInferredType())) {
            result = rowCount.map(value -> value > 0).defaultIfEmpty((Object)false);
        } else {
            throw new BindingException("Mapper method '" + this.command.getName() + "' has an unsupported return type: " + this.method.getReturnType());
        }
        return result;
    }

    private Flux<Object> executeWithVoid(ReactiveSqlSession sqlSession, Object[] args) {
        MappedStatement ms = sqlSession.getConfiguration().getMappedStatement(this.command.getName());
        if (Void.TYPE.equals(((ResultMap)ms.getResultMaps().get(0)).getType())) {
            throw new BindingException("method " + this.command.getName() + " needs either a @ResultMap annotation, a @ResultType annotation, or a resultType attribute in XML so a ResultHandler can be used as a parameter.");
        }
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            return sqlSession.selectList(this.command.getName(), param, rowBounds);
        }
        return sqlSession.selectList(this.command.getName(), param);
    }

    private <E> Flux<E> executeForMany(ReactiveSqlSession sqlSession, Object[] args) {
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            return sqlSession.selectList(this.command.getName(), param, rowBounds);
        }
        return sqlSession.selectList(this.command.getName(), param);
    }

    public static class MethodSignature {
        private final boolean returnsMany;
        private final boolean returnsVoid;
        private final Class<?> returnType;
        private final Class<?> returnInferredType;
        private final Integer resultHandlerIndex;
        private final Integer rowBoundsIndex;
        private final ParamNameResolver paramNameResolver;

        public MethodSignature(Configuration configuration, Class<?> mapperInterface, Method method) {
            Type resolvedReturnType = TypeParameterResolver.resolveReturnType((Method)method, mapperInterface);
            this.returnType = resolvedReturnType instanceof Class ? (Class<Object>)resolvedReturnType : (resolvedReturnType instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)resolvedReturnType).getRawType() : method.getReturnType());
            this.returnInferredType = MapperMethod.parseInferredClass(method.getGenericReturnType());
            this.returnsVoid = Void.TYPE.equals(this.returnInferredType);
            this.returnsMany = Flux.class.equals(this.returnType);
            this.rowBoundsIndex = this.getUniqueParamIndex(method, RowBounds.class);
            this.resultHandlerIndex = this.getUniqueParamIndex(method, ResultHandler.class);
            this.paramNameResolver = new ParamNameResolver(configuration, method);
            this.checkReactorType();
        }

        private void checkReactorType() {
            if (Mono.class.equals(this.returnType) && Collection.class.isAssignableFrom(this.returnInferredType)) {
                throw new UnsupportedOperationException("Return type assignable from Mono<Collection<T>> should be changed to Flux<T>");
            }
            if (Void.TYPE.equals(this.returnType)) {
                throw new UnsupportedOperationException("Return type is void should be changed to Mono<Void> or Flux<Void>");
            }
            if (!Mono.class.equals(this.returnType) && !Flux.class.equals(this.returnType)) {
                throw new UnsupportedOperationException("Return type should by either Mono or Flux");
            }
        }

        public Object convertArgsToSqlCommandParam(Object[] args) {
            return this.paramNameResolver.getNamedParams(args);
        }

        public boolean hasRowBounds() {
            return this.rowBoundsIndex != null;
        }

        public RowBounds extractRowBounds(Object[] args) {
            return this.hasRowBounds() ? (RowBounds)args[this.rowBoundsIndex] : null;
        }

        public boolean hasResultHandler() {
            return this.resultHandlerIndex != null;
        }

        public ResultHandler extractResultHandler(Object[] args) {
            return this.hasResultHandler() ? (ResultHandler)args[this.resultHandlerIndex] : null;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public Class<?> getReturnInferredType() {
            return this.returnInferredType;
        }

        public boolean returnsMany() {
            return this.returnsMany;
        }

        public boolean returnsVoid() {
            return this.returnsVoid;
        }

        private Integer getUniqueParamIndex(Method method, Class<?> paramType) {
            Integer index = null;
            Class<?>[] argTypes = method.getParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                if (!paramType.isAssignableFrom(argTypes[i])) continue;
                if (index == null) {
                    index = i;
                    continue;
                }
                throw new BindingException(method.getName() + " cannot have multiple " + paramType.getSimpleName() + " parameters");
            }
            return index;
        }
    }

    public static class SqlCommand {
        private final String name;
        private final SqlCommandType type;

        public SqlCommand(Configuration configuration, Class<?> mapperInterface, Method method) {
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            MappedStatement ms = this.resolveMappedStatement(mapperInterface, methodName, declaringClass, configuration);
            if (ms == null) {
                if (method.getAnnotation(Flush.class) != null) {
                    throw new UnsupportedOperationException("Unsupported execution command : " + SqlCommandType.FLUSH);
                }
                throw new BindingException("Invalid bound statement (not found): " + mapperInterface.getName() + "." + methodName);
            }
            this.name = ms.getId();
            this.type = ms.getSqlCommandType();
            if (this.type == SqlCommandType.UNKNOWN) {
                throw new BindingException("Unknown execution method for: " + this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public SqlCommandType getType() {
            return this.type;
        }

        private MappedStatement resolveMappedStatement(Class<?> mapperInterface, String methodName, Class<?> declaringClass, Configuration configuration) {
            String statementId = mapperInterface.getName() + "." + methodName;
            if (configuration.hasStatement(statementId)) {
                return configuration.getMappedStatement(statementId);
            }
            if (mapperInterface.equals(declaringClass)) {
                return null;
            }
            for (Class<?> superInterface : mapperInterface.getInterfaces()) {
                MappedStatement ms;
                if (!declaringClass.isAssignableFrom(superInterface) || (ms = this.resolveMappedStatement(superInterface, methodName, declaringClass, configuration)) == null) continue;
                return ms;
            }
            return null;
        }
    }
}

