/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context;

import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context.R2dbcMybatisDatabaseRoutingContextManager;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context.R2dbcMybatisDatabaseRoutingKeyInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class R2dbcMybatisDatabaseRoutingOperator {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisDatabaseRoutingOperator.class);

    public static <T> Mono<T> executeMono(String targetRoutingKey, Mono<T> mono) {
        return R2dbcMybatisDatabaseRoutingContextManager.currentRoutingHolderContext().flatMap(databaseRoutingContextHolder -> Mono.usingWhen((Publisher)Mono.just((Object)databaseRoutingContextHolder), routingContextHolder -> {
            try {
                return mono;
            }
            catch (Throwable ex) {
                return Mono.error((Throwable)ex);
            }
        }, routingContextHolder -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = routingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.empty();
        }, (routingContextHolder, err) -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = routingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.empty();
        }, routingContextHolder -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = routingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.empty();
        }).onErrorResume(ex -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = databaseRoutingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.error((Throwable)ex);
        })).contextWrite(R2dbcMybatisDatabaseRoutingContextManager.initializeDatabaseRoutingContext(targetRoutingKey)).contextWrite(R2dbcMybatisDatabaseRoutingContextManager.initializeDatabaseRoutingHolderContext());
    }

    public static <T> Flux<T> executeFlux(String targetRoutingKey, Flux<T> flux) {
        return R2dbcMybatisDatabaseRoutingContextManager.currentRoutingHolderContext().flatMapMany(databaseRoutingContextHolder -> Flux.usingWhen((Publisher)Mono.just((Object)databaseRoutingContextHolder), routingContextHolder -> {
            try {
                return flux;
            }
            catch (Throwable ex) {
                return Mono.error((Throwable)ex);
            }
        }, routingContextHolder -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = routingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.empty();
        }, (routingContextHolder, err) -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = routingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.empty();
        }, routingContextHolder -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = routingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Mono.empty();
        }).onErrorResume(ex -> {
            R2dbcMybatisDatabaseRoutingKeyInfo oldKeyInfo = databaseRoutingContextHolder.getDatabaseRoutingKeys().pollFirst();
            log.debug("Reset Current DataSourceType Key : {}", (Object)oldKeyInfo);
            return Flux.error((Throwable)ex);
        })).contextWrite(R2dbcMybatisDatabaseRoutingContextManager.initializeDatabaseRoutingContext(targetRoutingKey)).contextWrite(R2dbcMybatisDatabaseRoutingContextManager.initializeDatabaseRoutingHolderContext());
    }

    private R2dbcMybatisDatabaseRoutingOperator() {
    }
}

