/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context.R2dbcMybatisDatabaseRoutingContextHolder;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context.R2dbcMybatisDatabaseRoutingKeyInfo;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class R2dbcMybatisDatabaseRoutingContextManager {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisDatabaseRoutingContextManager.class);

    public static Mono<R2dbcMybatisDatabaseRoutingKeyInfo> currentRoutingContext() {
        return Mono.deferContextual(contextView -> Mono.justOrEmpty((Optional)contextView.getOrEmpty(R2dbcMybatisDatabaseRoutingKeyInfo.class)));
    }

    public static Mono<R2dbcMybatisDatabaseRoutingContextHolder> currentRoutingHolderContext() {
        return Mono.deferContextual(contextView -> Mono.justOrEmpty((Optional)contextView.getOrEmpty(R2dbcMybatisDatabaseRoutingContextHolder.class)));
    }

    public static Function<Context, Context> initializeDatabaseRoutingContext(String targetRoutingKey) {
        return context -> {
            R2dbcMybatisDatabaseRoutingKeyInfo r2dbcMybatisDatabaseRoutingKeyInfo = R2dbcMybatisDatabaseRoutingKeyInfo.of(targetRoutingKey);
            if (context.hasKey(R2dbcMybatisDatabaseRoutingContextHolder.class)) {
                R2dbcMybatisDatabaseRoutingContextHolder r2dbcMybatisDatabaseRoutingContextHolder = (R2dbcMybatisDatabaseRoutingContextHolder)context.get(R2dbcMybatisDatabaseRoutingContextHolder.class);
                r2dbcMybatisDatabaseRoutingContextHolder.getDatabaseRoutingKeys().push(r2dbcMybatisDatabaseRoutingKeyInfo);
                log.debug("Initialize database routing context with target routing key :{}", (Object)targetRoutingKey);
                return context.put(R2dbcMybatisDatabaseRoutingKeyInfo.class, (Object)r2dbcMybatisDatabaseRoutingKeyInfo);
            }
            R2dbcMybatisDatabaseRoutingContextHolder r2dbcMybatisDatabaseRoutingContextHolder = R2dbcMybatisDatabaseRoutingContextHolder.of(new ArrayDeque<R2dbcMybatisDatabaseRoutingKeyInfo>());
            r2dbcMybatisDatabaseRoutingContextHolder.getDatabaseRoutingKeys().push(r2dbcMybatisDatabaseRoutingKeyInfo);
            log.debug("Add database routing context with target routing key :{}", (Object)targetRoutingKey);
            return context.put(R2dbcMybatisDatabaseRoutingContextHolder.class, (Object)r2dbcMybatisDatabaseRoutingContextHolder).put(R2dbcMybatisDatabaseRoutingKeyInfo.class, (Object)r2dbcMybatisDatabaseRoutingKeyInfo);
        };
    }

    public static Function<Context, Context> initializeDatabaseRoutingHolderContext() {
        return context -> {
            if (context.hasKey(R2dbcMybatisDatabaseRoutingContextHolder.class)) {
                return context;
            }
            log.debug("Initialize database routing context holder success");
            return context.put(R2dbcMybatisDatabaseRoutingContextHolder.class, (Object)R2dbcMybatisDatabaseRoutingContextHolder.of(new ArrayDeque<R2dbcMybatisDatabaseRoutingKeyInfo>()));
        };
    }

    private R2dbcMybatisDatabaseRoutingContextManager() {
    }
}

