/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.r2dbc.connection.lookup.AbstractRoutingConnectionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.DynamicRoutingConnectionFactoryLoader;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.R2dbcMybatisRoutingConnectionFactoryCustomizer;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context.R2dbcMybatisDatabaseRoutingContextManager;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.context.R2dbcMybatisDatabaseRoutingKeyInfo;
import reactor.core.publisher.Mono;

public class R2dbcMybatisDynamicRoutingConnectionFactory
extends AbstractRoutingConnectionFactory
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisDynamicRoutingConnectionFactory.class);
    private final DynamicRoutingConnectionFactoryLoader dynamicRoutingConnectionFactoryLoader;
    private ConnectionFactory defaultConnectionFactory;
    private ApplicationContext applicationContext;

    public R2dbcMybatisDynamicRoutingConnectionFactory(DynamicRoutingConnectionFactoryLoader dynamicRoutingConnectionFactoryLoader) {
        this(null, dynamicRoutingConnectionFactoryLoader);
    }

    public R2dbcMybatisDynamicRoutingConnectionFactory(ConnectionFactory defaultConnectionFactory, DynamicRoutingConnectionFactoryLoader dynamicRoutingConnectionFactoryLoader) {
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.dynamicRoutingConnectionFactoryLoader = dynamicRoutingConnectionFactoryLoader;
    }

    public ConnectionFactoryMetadata getMetadata() {
        if (Objects.nonNull(this.defaultConnectionFactory)) {
            return super.getMetadata();
        }
        return () -> "MySQL";
    }

    protected Mono<Object> determineCurrentLookupKey() {
        return R2dbcMybatisDatabaseRoutingContextManager.currentRoutingContext().map(R2dbcMybatisDatabaseRoutingKeyInfo::getRoutingKey).cast(Object.class).doOnNext(value -> log.info("Determine current connection factory lookup key :" + value));
    }

    public Mono<ConnectionFactory> determineTargetConnectionFactory() {
        return super.determineTargetConnectionFactory();
    }

    public void afterPropertiesSet() {
        if (Objects.isNull(this.defaultConnectionFactory)) {
            this.defaultConnectionFactory = (ConnectionFactory)this.applicationContext.getBean(StringUtils.uncapitalize((String)ConnectionFactory.class.getSimpleName()), ConnectionFactory.class);
            this.setDefaultTargetConnectionFactory(this.defaultConnectionFactory);
        }
        this.setTargetConnectionFactories(this.loadConnectionFactory());
        this.applicationContext.getBeansOfType(R2dbcMybatisRoutingConnectionFactoryCustomizer.class).forEach((k, v) -> v.customize(this));
        super.afterPropertiesSet();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected Map<?, ConnectionFactory> loadConnectionFactory() {
        return this.dynamicRoutingConnectionFactoryLoader.load();
    }
}

