/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.mapper;

import org.apache.ibatis.executor.ErrorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSessionFactory;

public class R2dbcMapperFactoryBean<T>
implements FactoryBean<T>,
InitializingBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMapperFactoryBean.class);
    protected Class<T> mapperInterface;
    protected ReactiveSqlSessionFactory reactiveSqlSessionFactory;
    private boolean failFast;

    public R2dbcMapperFactoryBean() {
    }

    public R2dbcMapperFactoryBean(Class<T> clazz) {
        this.mapperInterface = clazz;
    }

    public T getObject() throws Exception {
        return (T)this.reactiveSqlSessionFactory.openSession().getMapper(this.mapperInterface);
    }

    public Class<?> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public void setSqlSessionFactory(ReactiveSqlSessionFactory reactiveSqlSessionFactory) {
        this.reactiveSqlSessionFactory = reactiveSqlSessionFactory;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.reactiveSqlSessionFactory, (String)"Property 'sqlSessionFactory' are required...");
        if (!this.reactiveSqlSessionFactory.getConfiguration().hasMapper(this.mapperInterface)) {
            try {
                this.reactiveSqlSessionFactory.getConfiguration().addMapper(this.mapperInterface);
            }
            catch (Exception e) {
                log.error("Error while adding the mapper '" + this.mapperInterface + "' to configuration.", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.failFast) {
            this.reactiveSqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }
}

