/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration.routing;

import io.r2dbc.spi.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcTransactionManagerAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.r2dbc.connection.R2dbcTransactionManager;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.defaults.DefaultReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.ReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration.MybatisLanguageDriverAutoConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration.routing.R2dbcMybatisMultiConnectionFactoryAutoInitializer;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.executor.SpringReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisRoutingConnectionFactoryProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.BeanNameDynamicRoutingConnectionFactoryLoader;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.DynamicRoutingConnectionFactoryLoader;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.routing.R2dbcMybatisDynamicRoutingConnectionFactory;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, R2dbcAutoConfiguration.class, R2dbcTransactionManagerAutoConfiguration.class})
@AutoConfigureAfter(value={MybatisLanguageDriverAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.r2dbc.mybatis.routing.enabled"}, havingValue="true")
public class R2dbcMybatisRoutingAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisRoutingAutoConfiguration.class);

    @ConfigurationProperties(prefix="spring.r2dbc.mybatis.routing")
    @Bean
    public R2dbcMybatisRoutingConnectionFactoryProperties r2dbcMybatisRoutingConnectionFactoryProperties() {
        return new R2dbcMybatisRoutingConnectionFactoryProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={DynamicRoutingConnectionFactoryLoader.class})
    public DynamicRoutingConnectionFactoryLoader dynamicRoutingConnectionFactoryLoader() {
        log.debug("No DynamicRoutingConnectionFactoryLoader Found, Use BeanNameDynamicRoutingConnectionFactoryLoader as default.");
        return new BeanNameDynamicRoutingConnectionFactoryLoader();
    }

    @Primary
    @Bean
    public R2dbcMybatisDynamicRoutingConnectionFactory r2dbcMybatisDynamicRoutingConnectionFactory(R2dbcMybatisMultiConnectionFactoryAutoInitializer r2dbcMybatisMultiConnectionFactoryAutoInitializer, DynamicRoutingConnectionFactoryLoader dynamicRoutingConnectionFactoryLoader) {
        return new R2dbcMybatisDynamicRoutingConnectionFactory(dynamicRoutingConnectionFactoryLoader);
    }

    @Primary
    @Bean
    public ReactiveSqlSessionFactory reactiveSqlSessionFactory(R2dbcMybatisConfiguration configuration) {
        SpringReactiveMybatisExecutor springReactiveMybatisExecutor = new SpringReactiveMybatisExecutor(configuration);
        return DefaultReactiveSqlSessionFactory.newBuilder().withR2dbcMybatisConfiguration(configuration).withReactiveMybatisExecutor((ReactiveMybatisExecutor)springReactiveMybatisExecutor).build();
    }

    @Primary
    @Bean
    public R2dbcTransactionManager r2dbcTransactionManager(R2dbcMybatisDynamicRoutingConnectionFactory r2dbcMybatisDynamicRoutingConnectionFactory) {
        return new R2dbcTransactionManager((ConnectionFactory)r2dbcMybatisDynamicRoutingConnectionFactory);
    }
}

