/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration.routing;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ValidationDepth;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisConnectionFactoryProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisRoutingConnectionFactoryProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.ConnectionFactoryOptionsCustomizer;

@Configuration
@ConditionalOnProperty(value={"spring.r2dbc.mybatis.routing.enabled"}, havingValue="true")
public class R2dbcMybatisMultiConnectionFactoryAutoInitializer
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisMultiConnectionFactoryAutoInitializer.class);
    private R2dbcMybatisRoutingConnectionFactoryProperties r2dbcMybatisRoutingConnectionFactoryProperties;
    private ObjectProvider<ConnectionFactoryOptionsCustomizer> connectionFactoryOptionsCustomizerProvider;
    private ConfigurableApplicationContext applicationContext;

    public void afterPropertiesSet() throws Exception {
        Optional<R2dbcMybatisConnectionFactoryProperties> optionalDefaultR2dbcMybatisConnectionFactoryProperties = this.r2dbcMybatisRoutingConnectionFactoryProperties.getDefinitions().stream().filter(R2dbcMybatisConnectionFactoryProperties::isAsDefault).findFirst();
        if (!optionalDefaultR2dbcMybatisConnectionFactoryProperties.isPresent()) {
            throw new IllegalStateException("When configuration using routing datasource , it should be set one to default at least , the property is : spring.r2dbc.mybatis.routing.definitions[?].as-default");
        }
        this.registerConnectionFactoryBean(optionalDefaultR2dbcMybatisConnectionFactoryProperties.get(), this.connectionFactoryOptionsCustomizerProvider, org.apache.commons.lang3.StringUtils.uncapitalize((String)ConnectionFactory.class.getSimpleName()));
        for (R2dbcMybatisConnectionFactoryProperties properties : this.r2dbcMybatisRoutingConnectionFactoryProperties.getDefinitions()) {
            this.registerConnectionFactoryBean(properties, this.connectionFactoryOptionsCustomizerProvider, null);
        }
    }

    protected void registerConnectionFactoryBean(R2dbcMybatisConnectionFactoryProperties r2dbcMybatisConnectionFactoryProperties, ObjectProvider<ConnectionFactoryOptionsCustomizer> connectionFactoryOptionsCustomizerProvider, String specificBeanName) {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)r2dbcMybatisConnectionFactoryProperties.getName(), (CharSequence)"defaultConnectionFactory")) {
            throw new IllegalStateException("When using Multi ConnectionFactory Routing, The ConnectionFactory defined in routing definitions ['defaultConnectionFactory' is not allowed](Url : " + r2dbcMybatisConnectionFactoryProperties.getR2dbcUrl() + ")");
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConnectionPool.class);
        ConnectionPoolConfiguration connectionPoolConfiguration = this.getConnectionPoolConfiguration(r2dbcMybatisConnectionFactoryProperties, connectionFactoryOptionsCustomizerProvider);
        beanDefinitionBuilder.addConstructorArgValue((Object)connectionPoolConfiguration);
        beanDefinitionBuilder.setDestroyMethodName("dispose");
        beanDefinitionBuilder.setScope("singleton");
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getBeanFactory();
        String beanName = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)specificBeanName, (CharSequence)r2dbcMybatisConnectionFactoryProperties.getName());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)beanName)) {
            throw new IllegalStateException("Using Multi ConnectionFactory Routing, The ConnectionFactory must be configured in properties (Url : " + r2dbcMybatisConnectionFactoryProperties.getR2dbcUrl() + ")");
        }
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    protected ConnectionPoolConfiguration getConnectionPoolConfiguration(R2dbcMybatisConnectionFactoryProperties r2DbcMybatisConnectionFactoryProperties, ObjectProvider<ConnectionFactoryOptionsCustomizer> connectionFactoryOptionsCustomizerProvider) {
        List<ConnectionFactoryOptionsCustomizer> connectionFactoryOptionsCustomizers;
        String determineConnectionFactoryUrl = r2DbcMybatisConnectionFactoryProperties.determineConnectionFactoryUrl();
        Assert.notNull((Object)determineConnectionFactoryUrl, (String)"R2DBC Connection URL must not be null");
        ConnectionFactoryOptions connectionFactoryOptions = ConnectionFactoryOptions.parse((CharSequence)determineConnectionFactoryUrl);
        if (Objects.nonNull(connectionFactoryOptionsCustomizerProvider) && !CollectionUtils.isEmpty(connectionFactoryOptionsCustomizers = connectionFactoryOptionsCustomizerProvider.orderedStream().collect(Collectors.toList()))) {
            ConnectionFactoryOptions.Builder builder = connectionFactoryOptions.mutate();
            connectionFactoryOptionsCustomizers.forEach(connectionFactoryOptionsCustomizer -> connectionFactoryOptionsCustomizer.customize(builder));
            connectionFactoryOptions = builder.build();
        }
        ConnectionFactory connectionFactory = ConnectionFactories.get((ConnectionFactoryOptions)connectionFactoryOptions);
        R2dbcMybatisConnectionFactoryProperties.Pool pool = r2DbcMybatisConnectionFactoryProperties.getPool();
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).name(r2DbcMybatisConnectionFactoryProperties.determineConnectionFactoryName()).maxSize(pool.getMaxSize().intValue()).initialSize(pool.getInitialSize().intValue()).maxIdleTime(pool.getMaxIdleTime()).acquireRetry(pool.getAcquireRetry()).backgroundEvictionInterval(pool.getBackgroundEvictionInterval()).maxAcquireTime(pool.getMaxAcquireTime()).maxCreateConnectionTime(pool.getMaxCreateConnectionTime()).maxLifeTime(pool.getMaxLifeTime()).validationDepth(pool.getValidationDepth());
        if (StringUtils.hasText((String)pool.getValidationQuery())) {
            builder.validationQuery(pool.getValidationQuery());
        } else {
            builder.validationDepth(ValidationDepth.LOCAL);
        }
        return builder.build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        this.r2dbcMybatisRoutingConnectionFactoryProperties = (R2dbcMybatisRoutingConnectionFactoryProperties)applicationContext.getBean(R2dbcMybatisRoutingConnectionFactoryProperties.class);
        this.connectionFactoryOptionsCustomizerProvider = applicationContext.getBeanProvider(ConnectionFactoryOptionsCustomizer.class);
    }
}

