/*
 *    Copyright 2009-2023 the original author or authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.executor;

import io.r2dbc.spi.Connection;
import org.springframework.r2dbc.connection.ConnectionFactoryUtils;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.DefaultReactiveMybatisExecutor;
import reactor.core.publisher.Mono;

/**
 * The type Spring reactive mybatis executor.
 * override closeConnection with {@link ConnectionFactoryUtils}
 * <p>
 * {@link org.springframework.r2dbc.core.DatabaseClient}
 *
 * @author Gang Cheng
 * @since 1.0.0
 */
public class SpringReactiveMybatisExecutor extends DefaultReactiveMybatisExecutor {

    /**
     * Instantiates a new Spring reactive mybatis executor.
     *
     * @param configuration the configuration
     */
    public SpringReactiveMybatisExecutor(R2dbcMybatisConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Mono<Void> closeConnection(Connection connection) {
        return ConnectionFactoryUtils.currentConnectionFactory(connectionFactory)
                .then()
                .onErrorResume(Exception.class, e -> Mono.from(connection.close()));
    }
}
