/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ValidationDepth;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.NestedIOException;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.r2dbc.connection.R2dbcTransactionManager;
import org.springframework.r2dbc.connection.TransactionAwareConnectionFactoryProxy;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.defaults.DefaultReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.ReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.type.R2dbcTypeHandlerAdapter;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration.MybatisLanguageDriverAutoConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration.SpringBootVFS;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.executor.SpringReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.mapper.R2dbcMapperFactoryBean;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.mapper.R2dbcMapperScannerConfigurer;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisConnectionFactoryProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.ConnectionFactoryOptionsCustomizer;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.R2dbcMybatisConfigurationCustomizer;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@AutoConfigureAfter(value={MybatisLanguageDriverAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class})
public class R2dbcMybatisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisAutoConfiguration.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();

    @ConfigurationProperties(value="spring.r2dbc.mybatis")
    @Bean
    public R2dbcMybatisConnectionFactoryProperties r2dbcConnectionFactoryProperties() {
        return new R2dbcMybatisConnectionFactoryProperties();
    }

    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @Bean(destroyMethod="dispose")
    public ConnectionPool connectionFactory(R2dbcMybatisConnectionFactoryProperties r2DbcMybatisConnectionFactoryProperties, ObjectProvider<ConnectionFactoryOptionsCustomizer> connectionFactoryOptionsCustomizerProvider) {
        ConnectionFactory connectionFactory;
        String determineConnectionFactoryUrl = r2DbcMybatisConnectionFactoryProperties.determineConnectionFactoryUrl();
        Assert.notNull((Object)determineConnectionFactoryUrl, (String)"R2DBC Connection URL must not be null");
        ConnectionFactoryOptions connectionFactoryOptions = ConnectionFactoryOptions.parse((CharSequence)determineConnectionFactoryUrl);
        List<ConnectionFactoryOptionsCustomizer> connectionFactoryOptionsCustomizers = connectionFactoryOptionsCustomizerProvider.orderedStream().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(connectionFactoryOptionsCustomizers)) {
            ConnectionFactoryOptions.Builder builder = connectionFactoryOptions.mutate();
            connectionFactoryOptionsCustomizers.forEach(connectionFactoryOptionsCustomizer -> connectionFactoryOptionsCustomizer.customize(builder));
            connectionFactoryOptions = builder.build();
        }
        if ((connectionFactory = ConnectionFactories.get((ConnectionFactoryOptions)connectionFactoryOptions)) instanceof ConnectionPool) {
            return (ConnectionPool)connectionFactory;
        }
        R2dbcMybatisConnectionFactoryProperties.Pool pool = r2DbcMybatisConnectionFactoryProperties.getPool();
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).name(r2DbcMybatisConnectionFactoryProperties.determineConnectionFactoryName()).maxSize(pool.getMaxSize().intValue()).initialSize(pool.getInitialSize().intValue()).maxIdleTime(pool.getMaxIdleTime()).acquireRetry(pool.getAcquireRetry()).backgroundEvictionInterval(pool.getBackgroundEvictionInterval()).maxAcquireTime(pool.getMaxAcquireTime()).maxCreateConnectionTime(pool.getMaxCreateConnectionTime()).maxLifeTime(pool.getMaxLifeTime()).metricsRecorder(pool.getMetricsRecorder()).validationDepth(pool.getValidationDepth());
        if (StringUtils.hasText((String)pool.getValidationQuery())) {
            builder.validationQuery(pool.getValidationQuery());
        } else {
            builder.validationDepth(ValidationDepth.LOCAL);
        }
        ConnectionPool connectionPool = new ConnectionPool(builder.build());
        log.info("Initialize Connection Pool Success");
        return connectionPool;
    }

    @ConfigurationProperties(value="r2dbc.mybatis")
    @Bean
    public R2dbcMybatisProperties r2dbcMybatisProperties() {
        return new R2dbcMybatisProperties();
    }

    @Bean
    public R2dbcMybatisConfiguration configuration(R2dbcMybatisProperties r2dbcMybatisProperties, ObjectProvider<TypeHandler<?>> typeHandlerProvider, ObjectProvider<R2dbcMybatisConfigurationCustomizer> configurationCustomizerProvider, ObjectProvider<R2dbcTypeHandlerAdapter<?>> r2dbcTypeHandlerAdapterProvider, ObjectProvider<LanguageDriver> languageDriversProvider) throws Exception {
        Resource[] mapperLocations;
        R2dbcMybatisConfiguration r2dbcMybatisConfiguration = Optional.ofNullable(r2dbcMybatisProperties.getConfiguration()).orElse(new R2dbcMybatisConfiguration());
        r2dbcMybatisConfiguration.setVfsImpl(SpringBootVFS.class);
        if (r2dbcMybatisProperties.getConfigurationProperties() != null) {
            r2dbcMybatisConfiguration.setVariables(r2dbcMybatisProperties.getConfigurationProperties());
        }
        if (StringUtils.hasLength((String)r2dbcMybatisProperties.getTypeAliasesPackage())) {
            this.scanClasses(r2dbcMybatisProperties.getTypeAliasesPackage(), r2dbcMybatisProperties.getTypeAliasesSuperType()).stream().filter(clazz -> !clazz.isAnonymousClass()).filter(clazz -> !clazz.isInterface()).filter(clazz -> !clazz.isMemberClass()).forEach(arg_0 -> ((TypeAliasRegistry)r2dbcMybatisConfiguration.getTypeAliasRegistry()).registerAlias(arg_0));
        }
        if (!ObjectUtils.isEmpty((Object[])r2dbcMybatisProperties.getTypeAliases())) {
            Stream.of(r2dbcMybatisProperties.getTypeAliases()).forEach(typeAlias -> {
                r2dbcMybatisConfiguration.getTypeAliasRegistry().registerAlias(typeAlias);
                log.debug("Registered type alias: '" + typeAlias + "'");
            });
        }
        if (StringUtils.hasLength((String)r2dbcMybatisProperties.getTypeHandlersPackage())) {
            this.scanClasses(r2dbcMybatisProperties.getTypeHandlersPackage(), TypeHandler.class).stream().filter(clazz -> !clazz.isAnonymousClass()).filter(clazz -> !clazz.isInterface()).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).forEach(arg_0 -> ((TypeHandlerRegistry)r2dbcMybatisConfiguration.getTypeHandlerRegistry()).register(arg_0));
        }
        typeHandlerProvider.stream().forEach(typeHandler -> {
            r2dbcMybatisConfiguration.getTypeHandlerRegistry().register(typeHandler);
            log.debug("Registered type handler: '" + typeHandler + "'");
        });
        if (StringUtils.hasLength((String)r2dbcMybatisProperties.getR2dbcTypeHandlerAdapterPackage())) {
            r2dbcMybatisConfiguration.getR2dbcTypeHandlerAdapterRegistry().register(r2dbcMybatisProperties.getR2dbcTypeHandlerAdapterPackage());
        }
        r2dbcTypeHandlerAdapterProvider.stream().forEach(r2dbcTypeHandlerAdapter -> {
            r2dbcMybatisConfiguration.addR2dbcTypeHandlerAdapter(r2dbcTypeHandlerAdapter);
            log.debug("Registered r2dbc type handler adapter: '" + r2dbcTypeHandlerAdapter + "'");
        });
        r2dbcMybatisConfiguration.setDefaultEnumTypeHandler(r2dbcMybatisProperties.getDefaultEnumTypeHandler());
        Object[] availableLanguageDrivers = (LanguageDriver[])languageDriversProvider.stream().toArray(LanguageDriver[]::new);
        Class<Object> defaultLanguageDriver = r2dbcMybatisProperties.getDefaultScriptingLanguageDriver();
        if (!ObjectUtils.isEmpty((Object[])availableLanguageDrivers)) {
            Stream.of(availableLanguageDrivers).forEach(languageDriver -> {
                r2dbcMybatisConfiguration.getLanguageRegistry().register(languageDriver);
                log.debug("Registered scripting language driver: '" + languageDriver + "'");
            });
            if (defaultLanguageDriver == null && availableLanguageDrivers.length == 1) {
                defaultLanguageDriver = availableLanguageDrivers[0].getClass();
            }
        }
        if (defaultLanguageDriver != null) {
            r2dbcMybatisConfiguration.setDefaultScriptingLanguage(defaultLanguageDriver);
        }
        if ((mapperLocations = r2dbcMybatisProperties.resolveMapperLocations()) != null) {
            if (mapperLocations.length == 0) {
                log.warn("Property 'mapperLocations' was specified but matching resources are not found.");
            } else {
                for (Resource mapperLocation : mapperLocations) {
                    if (mapperLocation == null) continue;
                    try {
                        XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), (org.apache.ibatis.session.Configuration)r2dbcMybatisConfiguration, mapperLocation.toString(), r2dbcMybatisConfiguration.getSqlFragments());
                        xmlMapperBuilder.parse();
                    }
                    catch (Exception e) {
                        throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                    }
                    finally {
                        ErrorContext.instance().reset();
                    }
                    log.debug("Parsed mapper file: '" + mapperLocation + "'");
                }
            }
        } else {
            log.debug("Property 'mapperLocations' was not specified.");
        }
        configurationCustomizerProvider.orderedStream().forEach(r2dbcMybatisConfigurationCustomizer -> r2dbcMybatisConfigurationCustomizer.customize(r2dbcMybatisConfiguration));
        return r2dbcMybatisConfiguration;
    }

    private Set<Class<?>> scanClasses(String packagePatterns, Class<?> assignableType) throws IOException {
        String[] packagePatternArray;
        HashSet classes = new HashSet();
        for (String packagePattern : packagePatternArray = StringUtils.tokenizeToStringArray((String)packagePatterns, (String)",; \t\n")) {
            Resource[] resources;
            for (Resource resource : resources = RESOURCE_PATTERN_RESOLVER.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packagePattern) + "/**/*.class")) {
                try {
                    ClassMetadata classMetadata = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    Class clazz = Resources.classForName((String)classMetadata.getClassName());
                    if (assignableType != null && !assignableType.isAssignableFrom(clazz)) continue;
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    log.warn("Cannot load the '" + resource + "'. Cause by " + e.toString());
                }
            }
        }
        return classes;
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveTransactionManager.class})
    public R2dbcTransactionManager connectionFactoryTransactionManager(ConnectionFactory connectionFactory) {
        return new R2dbcTransactionManager(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveSqlSessionFactory.class})
    public ReactiveSqlSessionFactory reactiveSqlSessionFactoryWithTransaction(R2dbcMybatisConfiguration configuration, ConnectionFactory connectionFactory) {
        if (!TransactionAwareConnectionFactoryProxy.class.isAssignableFrom(connectionFactory.getClass())) {
            configuration.setConnectionFactory((ConnectionFactory)new TransactionAwareConnectionFactoryProxy(connectionFactory));
        } else {
            configuration.setConnectionFactory(connectionFactory);
        }
        SpringReactiveMybatisExecutor springReactiveMybatisExecutor = new SpringReactiveMybatisExecutor(configuration);
        return DefaultReactiveSqlSessionFactory.newBuilder().withR2dbcMybatisConfiguration(configuration).withReactiveMybatisExecutor((ReactiveMybatisExecutor)springReactiveMybatisExecutor).withDefaultConnectionFactoryProxy(false).build();
    }

    @Configuration
    @Import(value={AutoConfiguredMapperScannerRegistrar.class})
    @ConditionalOnMissingBean(value={R2dbcMapperFactoryBean.class, R2dbcMapperScannerConfigurer.class})
    public static class R2dbcMapperScannerRegistrarNotFoundConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() {
            log.debug("Not found configuration for registering mapper bean using @R2dbcMapperScan, R2dbcMapperFactoryBean and R2dbcMapperScannerConfigurer.");
        }
    }

    public static class AutoConfiguredMapperScannerRegistrar
    implements BeanFactoryAware,
    EnvironmentAware,
    ImportBeanDefinitionRegistrar {
        private BeanFactory beanFactory;
        private Environment environment;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            boolean injectSqlSession;
            if (!AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                log.debug("Could not determine auto-configuration package, automatic mapper scanning disabled.");
                return;
            }
            log.debug("Searching for mappers annotated with @Mapper");
            List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
            if (log.isDebugEnabled()) {
                packages.forEach(pkg -> log.debug("Using auto-configuration base package '{}'", pkg));
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(R2dbcMapperScannerConfigurer.class);
            builder.addPropertyValue("processPropertyPlaceHolders", (Object)true);
            builder.addPropertyValue("annotationClass", Mapper.class);
            builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString((Collection)packages));
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(R2dbcMapperScannerConfigurer.class);
            Set propertyNames = Stream.of(beanWrapper.getPropertyDescriptors()).map(FeatureDescriptor::getName).collect(Collectors.toSet());
            if (propertyNames.contains("lazyInitialization")) {
                builder.addPropertyValue("lazyInitialization", (Object)"${mybatis.lazy-initialization:false}");
            }
            if (propertyNames.contains("defaultScope")) {
                builder.addPropertyValue("defaultScope", (Object)"${mybatis.mapper-default-scope:}");
            }
            if ((injectSqlSession = ((Boolean)this.environment.getProperty("mybatis.inject-sql-session-on-mapper-scan", Boolean.class, (Object)Boolean.TRUE)).booleanValue()) && this.beanFactory instanceof ListableBeanFactory) {
                ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
                Optional.ofNullable(this.getBeanNameForType(ReactiveSqlSessionFactory.class, listableBeanFactory)).ifPresent(s -> builder.addPropertyValue("sqlSessionFactoryBeanName", s));
            }
            builder.setRole(2);
            registry.registerBeanDefinition(MapperScannerConfigurer.class.getName(), (BeanDefinition)builder.getBeanDefinition());
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        private String getBeanNameForType(Class<?> type, ListableBeanFactory factory) {
            String[] beanNames = factory.getBeanNamesForType(type);
            return beanNames.length > 0 ? beanNames[0] : null;
        }
    }
}

