/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.configuration;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ValidationDepth;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.r2dbc.connection.R2dbcTransactionManager;
import org.springframework.r2dbc.connection.TransactionAwareConnectionFactoryProxy;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.util.StringUtils;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.defaults.DefaultReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.ReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.executor.SpringReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisConnectionFactoryProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties.R2dbcMybatisProperties;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.R2dbcAutoConfiguredMapperScannerRegistrar;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.R2dbcMapperScannerRegistrar;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={R2dbcAutoConfiguredMapperScannerRegistrar.class, R2dbcMapperScannerRegistrar.class})
@ConditionalOnClass(value={ConnectionFactory.class})
public class R2dbcMybatisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMybatisAutoConfiguration.class);

    @ConfigurationProperties(value="r2dbc.mybatis")
    @Bean
    public R2dbcMybatisProperties r2dbcMybatisProperties() {
        return new R2dbcMybatisProperties();
    }

    @ConfigurationProperties(value="spring.r2dbc.mybatis")
    @Bean
    public R2dbcMybatisConnectionFactoryProperties r2dbcConnectionFactoryProperties() {
        return new R2dbcMybatisConnectionFactoryProperties();
    }

    @Bean
    public R2dbcMybatisConfiguration configuration(R2dbcMybatisProperties properties) {
        R2dbcMybatisConfiguration configuration = new R2dbcMybatisConfiguration();
        configuration.setMapUnderscoreToCamelCase(properties.isMapUnderscoreToCamelCase());
        if (StringUtils.hasText((String)properties.getTypeAliasesPackage())) {
            String[] typeAliasPackageArray;
            for (String string : typeAliasPackageArray = StringUtils.tokenizeToStringArray((String)properties.getTypeAliasesPackage(), (String)",; \t\n")) {
                configuration.getTypeAliasRegistry().registerAliases(string, Object.class);
            }
        } else {
            log.info("Type Alias Package Is Empty");
        }
        Resource[] mapperLocations = properties.resolveMapperLocations();
        if (mapperLocations != null && mapperLocations.length > 0) {
            for (String string : mapperLocations) {
                if (string == null) continue;
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(string.getInputStream(), (org.apache.ibatis.session.Configuration)configuration, string.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to parse mapping resource: '" + string + "'", e);
                }
                finally {
                    ErrorContext.instance().reset();
                }
            }
        } else {
            throw new IllegalArgumentException("mapperLocations cannot be empty...");
        }
        return configuration;
    }

    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @Bean(destroyMethod="dispose")
    public ConnectionPool connectionFactory(R2dbcMybatisConnectionFactoryProperties r2DbcMybatisConnectionFactoryProperties) {
        ConnectionFactory connectionFactory = ConnectionFactories.get((String)r2DbcMybatisConnectionFactoryProperties.determineConnectionFactoryUrl());
        if (connectionFactory instanceof ConnectionPool) {
            return (ConnectionPool)connectionFactory;
        }
        R2dbcMybatisConnectionFactoryProperties.Pool pool = r2DbcMybatisConnectionFactoryProperties.getPool();
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).name(r2DbcMybatisConnectionFactoryProperties.determineConnectionFactoryName()).maxSize(pool.getMaxSize().intValue()).initialSize(pool.getInitialSize().intValue()).maxIdleTime(pool.getMaxIdleTime()).acquireRetry(pool.getAcquireRetry()).backgroundEvictionInterval(pool.getBackgroundEvictionInterval()).maxAcquireTime(pool.getMaxAcquireTime()).maxCreateConnectionTime(pool.getMaxCreateConnectionTime()).maxLifeTime(pool.getMaxLifeTime()).validationDepth(pool.getValidationDepth());
        if (StringUtils.hasText((String)pool.getValidationQuery())) {
            builder.validationQuery(pool.getValidationQuery());
        } else {
            builder.validationDepth(ValidationDepth.LOCAL);
        }
        ConnectionPool connectionPool = new ConnectionPool(builder.build());
        log.info("Initial Connection Pool Bean Success");
        return connectionPool;
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveTransactionManager.class})
    public R2dbcTransactionManager connectionFactoryTransactionManager(ConnectionFactory connectionFactory) {
        return new R2dbcTransactionManager(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveSqlSessionFactory.class})
    public ReactiveSqlSessionFactory reactiveSqlSessionFactoryWithTransaction(R2dbcMybatisConfiguration configuration, ConnectionFactory connectionFactory) {
        if (!TransactionAwareConnectionFactoryProxy.class.isAssignableFrom(connectionFactory.getClass())) {
            configuration.setConnectionFactory((ConnectionFactory)new TransactionAwareConnectionFactoryProxy(connectionFactory));
        } else {
            configuration.setConnectionFactory(connectionFactory);
        }
        SpringReactiveMybatisExecutor springReactiveMybatisExecutor = new SpringReactiveMybatisExecutor(configuration);
        return DefaultReactiveSqlSessionFactory.newBuilder().withR2dbcMybatisConfiguration(configuration).withReactiveMybatisExecutor((ReactiveMybatisExecutor)springReactiveMybatisExecutor).withDefaultConnectionFactoryProxy(false).build();
    }
}

