/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.R2dbcClasspathMapperScanner;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.support.R2dbcMapperFactoryBean;

public class R2dbcMapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(R2dbcMapperScannerRegistrar.class);
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
        this.registerBeanDefinitions(importingClassMetadata, registry);
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScan.class.getName()));
        if (annoAttrs != null) {
            Class mapperFactoryBeanClass;
            Class generatorClass;
            Class annotationClass;
            R2dbcClasspathMapperScanner scanner = new R2dbcClasspathMapperScanner(registry);
            if (this.resourceLoader != null) {
                scanner.setResourceLoader(this.resourceLoader);
            }
            if (!Annotation.class.equals((Object)(annotationClass = annoAttrs.getClass("annotationClass")))) {
                scanner.setAnnotationClass(annotationClass);
            }
            if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
                scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass));
            }
            if (!R2dbcMapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
                scanner.setMapperFactoryBean((R2dbcMapperFactoryBean)BeanUtils.instantiateClass((Class)mapperFactoryBeanClass));
            }
            scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
            ArrayList<String> basePackages = new ArrayList<String>();
            for (String pkg : annoAttrs.getStringArray("value")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
            for (String pkg : annoAttrs.getStringArray("basePackages")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
            for (Class clazz : annoAttrs.getClassArray("basePackageClasses")) {
                basePackages.add(ClassUtils.getPackageName((Class)clazz));
            }
            scanner.registerFilters();
            scanner.doScan(StringUtils.toStringArray(basePackages));
        } else {
            log.debug("MapperScan is not configured,default by scan with spring context");
        }
    }
}

