/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class R2dbcMybatisProperties {
    public static final String PREFIX = "r2dbc.mybatis";
    private boolean mapUnderscoreToCamelCase;
    private String[] mapperLocations;
    private String typeAliasesPackage;

    public Resource[] resolveMapperLocations() {
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.mapperLocations != null) {
            for (String mapperLocation : this.mapperLocations) {
                try {
                    Resource[] mappers = resourceResolver.getResources(mapperLocation);
                    resources.addAll(Arrays.asList(mappers));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return resources.toArray(new Resource[0]);
    }

    public boolean isMapUnderscoreToCamelCase() {
        return this.mapUnderscoreToCamelCase;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public void setMapUnderscoreToCamelCase(boolean mapUnderscoreToCamelCase) {
        this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public String toString() {
        return "R2dbcMybatisProperties(mapUnderscoreToCamelCase=" + this.isMapUnderscoreToCamelCase() + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ")";
    }
}

