/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties;

import io.r2dbc.spi.ValidationDepth;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.UUID;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import reactor.util.annotation.Nullable;

public class R2dbcMybatisConnectionFactoryProperties {
    public static final String PREFIX = "spring.r2dbc.mybatis";
    private String name;
    private boolean generateUniqueName = true;
    private String r2dbcUrl;
    private String username;
    private String password;
    private Pool pool = new Pool();
    private Boolean enableMetrics = Boolean.FALSE;

    public String determineConnectionFactoryName() {
        if (this.generateUniqueName && !StringUtils.hasText((String)this.name)) {
            this.name = UUID.randomUUID().toString();
        }
        return this.name;
    }

    public String determineConnectionFactoryUrl() {
        String encodedPassword;
        String encodedUsername;
        if (!StringUtils.hasText((String)this.r2dbcUrl)) {
            return null;
        }
        try {
            encodedUsername = URLEncoder.encode(this.username, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUsername = this.username;
        }
        try {
            encodedPassword = URLEncoder.encode(this.password, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedPassword = this.password;
        }
        String credential = encodedUsername + (this.password == null || this.password.isEmpty() ? "" : ":" + encodedPassword);
        boolean isMariadbConnectionfactoryPresent = ClassUtils.isPresent((String)"org.mariadb.r2dbc.MariadbConnectionFactory", (ClassLoader)this.getClass().getClassLoader());
        if (isMariadbConnectionfactoryPresent && this.r2dbcUrl.startsWith("r2dbc:mysql:")) {
            this.r2dbcUrl = this.r2dbcUrl.replace("r2dbc:mysql:", "r2dbc:mariadb:");
        }
        this.r2dbcUrl = this.r2dbcUrl.replace("//", "//" + credential + "@");
        return this.r2dbcUrl;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGenerateUniqueName() {
        return this.generateUniqueName;
    }

    public String getR2dbcUrl() {
        return this.r2dbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Boolean getEnableMetrics() {
        return this.enableMetrics;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGenerateUniqueName(boolean generateUniqueName) {
        this.generateUniqueName = generateUniqueName;
    }

    public void setR2dbcUrl(String r2dbcUrl) {
        this.r2dbcUrl = r2dbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setEnableMetrics(Boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    public String toString() {
        return "R2dbcMybatisConnectionFactoryProperties(name=" + this.getName() + ", generateUniqueName=" + this.isGenerateUniqueName() + ", r2dbcUrl=" + this.getR2dbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", pool=" + this.getPool() + ", enableMetrics=" + this.getEnableMetrics() + ")";
    }

    public static class Pool {
        private Integer initialSize = 1;
        private Integer maxSize = 10;
        private Duration maxIdleTime = Duration.ofMinutes(30L);
        private Duration maxCreateConnectionTime = Duration.ZERO;
        private Duration maxAcquireTime = Duration.ZERO;
        private Duration maxLifeTime = Duration.ZERO;
        @Nullable
        private String validationQuery;
        private ValidationDepth validationDepth = ValidationDepth.REMOTE;
        private int acquireRetry = 1;
        private Duration backgroundEvictionInterval = Duration.ofNanos(-1L);

        public Integer getInitialSize() {
            return this.initialSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public Duration getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public Duration getMaxCreateConnectionTime() {
            return this.maxCreateConnectionTime;
        }

        public Duration getMaxAcquireTime() {
            return this.maxAcquireTime;
        }

        public Duration getMaxLifeTime() {
            return this.maxLifeTime;
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public ValidationDepth getValidationDepth() {
            return this.validationDepth;
        }

        public int getAcquireRetry() {
            return this.acquireRetry;
        }

        public Duration getBackgroundEvictionInterval() {
            return this.backgroundEvictionInterval;
        }

        public void setInitialSize(Integer initialSize) {
            this.initialSize = initialSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public void setMaxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public void setMaxCreateConnectionTime(Duration maxCreateConnectionTime) {
            this.maxCreateConnectionTime = maxCreateConnectionTime;
        }

        public void setMaxAcquireTime(Duration maxAcquireTime) {
            this.maxAcquireTime = maxAcquireTime;
        }

        public void setMaxLifeTime(Duration maxLifeTime) {
            this.maxLifeTime = maxLifeTime;
        }

        public void setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
        }

        public void setValidationDepth(ValidationDepth validationDepth) {
            this.validationDepth = validationDepth;
        }

        public void setAcquireRetry(int acquireRetry) {
            this.acquireRetry = acquireRetry;
        }

        public void setBackgroundEvictionInterval(Duration backgroundEvictionInterval) {
            this.backgroundEvictionInterval = backgroundEvictionInterval;
        }

        public String toString() {
            return "R2dbcMybatisConnectionFactoryProperties.Pool(initialSize=" + this.getInitialSize() + ", maxSize=" + this.getMaxSize() + ", maxIdleTime=" + this.getMaxIdleTime() + ", maxCreateConnectionTime=" + this.getMaxCreateConnectionTime() + ", maxAcquireTime=" + this.getMaxAcquireTime() + ", maxLifeTime=" + this.getMaxLifeTime() + ", validationQuery=" + this.getValidationQuery() + ", validationDepth=" + this.getValidationDepth() + ", acquireRetry=" + this.getAcquireRetry() + ", backgroundEvictionInterval=" + this.getBackgroundEvictionInterval() + ")";
        }
    }
}

