/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.support;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorProperties;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesHolder;

public class GeneratedModelCustomizer {
    public void customizeLombokGeneratedIfConfigured(Interface interfaze, IntrospectedTable introspectedTable) {
        GeneratorProperties generatorProperties = GeneratorPropertiesHolder.getInstance().getGeneratorProperties();
        Set<String> lombokAnnotations = generatorProperties.getLombokAnnotations();
        if (!lombokAnnotations.contains("lombok.Generated")) {
            return;
        }
        interfaze.addImportedType(new FullyQualifiedJavaType("lombok.Generated"));
        interfaze.addAnnotation("@Generated");
    }

    public void customizeLombok(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableRemarks = (String)StringUtils.defaultIfBlank((CharSequence)introspectedTable.getRemarks(), (CharSequence)"auto generated");
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" * " + tableRemarks);
        topLevelClass.addJavaDocLine(" * ");
        topLevelClass.addJavaDocLine(" * @author AutoGenerated");
        topLevelClass.addJavaDocLine(" */");
        GeneratorProperties generatorProperties = GeneratorPropertiesHolder.getInstance().getGeneratorProperties();
        topLevelClass.getFields().forEach(field -> {
            field.setVisibility(generatorProperties.getFieldVisibility());
            field.setFinal(generatorProperties.isFinalField());
        });
        Set<String> lombokConfigs = generatorProperties.getLombokAnnotations();
        if (Objects.isNull(lombokConfigs) || lombokConfigs.isEmpty()) {
            return;
        }
        lombokConfigs.forEach(lombokAnnotationName -> {
            String lombokAnnotation;
            String lombokImport;
            if (!StringUtils.startsWith((CharSequence)lombokAnnotationName, (CharSequence)"lombok")) {
                return;
            }
            if (lombokAnnotationName.contains("(")) {
                String pureAnnotation = StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)lombokAnnotationName, (String)"("), (String)"."), (String)"(");
                lombokImport = StringUtils.substringBefore((String)lombokAnnotationName, (String)"(");
                lombokAnnotation = StringUtils.substringAfter((String)lombokAnnotationName, (String)StringUtils.substringBeforeLast((String)lombokImport, (String)pureAnnotation));
            } else {
                lombokAnnotation = StringUtils.substringAfterLast((String)lombokAnnotationName, (String)".");
                lombokImport = lombokAnnotationName;
            }
            topLevelClass.addImportedType(lombokImport);
            topLevelClass.addAnnotation("@" + lombokAnnotation);
        });
    }

    public void customizeModelConstant(Context context, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            Field field = new Field(introspectedColumn.getActualColumnName().toUpperCase(), new FullyQualifiedJavaType(String.class.getName()));
            field.setVisibility(JavaVisibility.PUBLIC);
            field.setStatic(true);
            field.setFinal(true);
            field.setInitializationString("\"" + introspectedColumn.getJavaProperty() + "\"");
            context.getCommentGenerator().addClassComment((InnerClass)topLevelClass, introspectedTable);
            topLevelClass.addField(field);
            Field columnField = new Field("DB_" + introspectedColumn.getActualColumnName().toUpperCase(), new FullyQualifiedJavaType(String.class.getName()));
            columnField.setVisibility(JavaVisibility.PUBLIC);
            columnField.setStatic(true);
            columnField.setFinal(true);
            columnField.setInitializationString("\"" + introspectedColumn.getActualColumnName() + "\"");
            topLevelClass.addField(columnField);
        }
    }
}

