/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.properties;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.representer.Representer;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorProperties;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesLoader;

public class YamlGeneratorPropertiesLoader
implements GeneratorPropertiesLoader {
    private final Yaml yaml;
    private String classpathConfigurationFileName;
    private String customConfigurationFileName;

    public YamlGeneratorPropertiesLoader() {
        this(null);
    }

    public YamlGeneratorPropertiesLoader(String configurationFileName) {
        if (StringUtils.startsWith((CharSequence)configurationFileName, (CharSequence)"classpath:")) {
            this.classpathConfigurationFileName = StringUtils.substringAfter((String)configurationFileName, (String)"classpath:");
        } else if (StringUtils.isNotBlank((CharSequence)configurationFileName)) {
            this.customConfigurationFileName = configurationFileName;
        }
        Representer represent = new Representer(new DumperOptions());
        represent.getPropertyUtils().setSkipMissingProperties(true);
        this.yaml = new Yaml((BaseConstructor)new Constructor(GeneratorProperties.class, new LoaderOptions()), represent);
        this.yaml.setBeanAccess(BeanAccess.FIELD);
    }

    @Override
    public GeneratorProperties load() {
        InputStream configurationFileInputStream = this.getConfigurationFileInputStream();
        if (Objects.isNull(configurationFileInputStream)) {
            throw new IllegalArgumentException("Can not load configuration file with specific configuration");
        }
        return (GeneratorProperties)this.yaml.load(configurationFileInputStream);
    }

    private InputStream getConfigurationFileInputStream() {
        if (StringUtils.isNotBlank((CharSequence)this.customConfigurationFileName)) {
            return new FileInputStream(this.customConfigurationFileName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.classpathConfigurationFileName)) {
            return this.getClass().getClassLoader().getResourceAsStream(this.customConfigurationFileName);
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("mybatis-generator.yaml");
        if (Objects.nonNull(inputStream)) {
            return inputStream;
        }
        inputStream = this.getClass().getClassLoader().getResourceAsStream("mybatis-generator.yml");
        if (Objects.nonNull(inputStream)) {
            return inputStream;
        }
        return null;
    }
}

