/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.plugin.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.FragmentGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorProperties;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesHolder;
import pro.chenggang.project.reactive.mybatis.support.generator.support.GeneratedModelCustomizer;

public class DynamicGeneratorPlugin
extends PluginAdapter {
    private final GeneratedModelCustomizer generatedModelCustomizer = new GeneratedModelCustomizer();
    private boolean autoGenerateModel = true;
    private boolean hasDynamicSqlInClasspath = false;

    public boolean validate(List<String> warnings) {
        try {
            Class<?> aClass = Class.forName("org.mybatis.dynamic.sql.SqlBuilder");
            this.hasDynamicSqlInClasspath = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.autoGenerateModel = Boolean.parseBoolean(this.properties.getProperty("autoGenerateModel", "true"));
        return this.hasDynamicSqlInClasspath;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        Optional<IntrospectedColumn> optionalIntrospectedColumn;
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.generatedModelCustomizer.customizeLombokGeneratedIfConfigured(interfaze, introspectedTable);
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
            interfaze.addAnnotation("@Mapper");
        }
        String tableRemarks = (String)StringUtils.defaultIfBlank((CharSequence)introspectedTable.getRemarks(), (CharSequence)"auto generated");
        interfaze.addJavaDocLine("/**");
        interfaze.addJavaDocLine(" * " + tableRemarks + " mapper");
        interfaze.addJavaDocLine(" * ");
        interfaze.addJavaDocLine(" * @author AutoGenerated");
        interfaze.addJavaDocLine(" */");
        boolean hasCommonSelectMapperClass = false;
        try {
            Class<?> aClass = Class.forName("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonSelectMapper");
            hasCommonSelectMapperClass = true;
        }
        catch (ClassNotFoundException aClass) {
            // empty catch block
        }
        if (hasCommonSelectMapperClass) {
            FullyQualifiedJavaType commonSelectMapperType = new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonSelectMapper");
            interfaze.addSuperInterface(commonSelectMapperType);
            interfaze.addImportedType(commonSelectMapperType);
        }
        interfaze.getImportedTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL<org.mybatis.dynamic.sql.update.UpdateModel>"));
        interfaze.getImportedTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.MyBatis3Utils"));
        interfaze.getImportedTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonCountMapper"));
        interfaze.getImportedTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonDeleteMapper"));
        interfaze.getImportedTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonInsertMapper"));
        interfaze.getImportedTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonUpdateMapper"));
        interfaze.getSuperInterfaceTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonCountMapper"));
        interfaze.getSuperInterfaceTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonDeleteMapper"));
        interfaze.getSuperInterfaceTypes().removeIf(item -> StringUtils.startsWith((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonInsertMapper"));
        interfaze.getSuperInterfaceTypes().removeIf(item -> StringUtils.equals((CharSequence)item.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.util.mybatis3.CommonUpdateMapper"));
        interfaze.addSuperInterface(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonCountMapper"));
        interfaze.addSuperInterface(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonDeleteMapper"));
        FullyQualifiedJavaType commonInsertMapperJavaType = new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonInsertMapper");
        commonInsertMapperJavaType.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        interfaze.addSuperInterface(commonInsertMapperJavaType);
        interfaze.addSuperInterface(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonUpdateMapper"));
        interfaze.addImportedType(new FullyQualifiedJavaType("reactor.core.publisher.Mono"));
        interfaze.addImportedType(new FullyQualifiedJavaType("reactor.core.publisher.Flux"));
        interfaze.addImportedType(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.ReactiveMyBatis3Utils"));
        interfaze.addImportedType(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonCountMapper"));
        interfaze.addImportedType(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonDeleteMapper"));
        interfaze.addImportedType(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonInsertMapper"));
        interfaze.addImportedType(new FullyQualifiedJavaType("pro.chenggang.project.reactive.mybatis.support.r2dbc.dynamic.CommonUpdateMapper"));
        GeneratorProperties generatorProperties = GeneratorPropertiesHolder.getInstance().getGeneratorProperties();
        if (generatorProperties.isGenerateReturnedKey() && (optionalIntrospectedColumn = introspectedTable.getPrimaryKeyColumns().stream().filter(IntrospectedColumn::isAutoIncrement).findFirst()).isPresent()) {
            this.generateInsertWithGeneratedKey(interfaze, introspectedTable);
        }
        return true;
    }

    public void generateInsertWithGeneratedKey(Interface interfaze, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        FullyQualifiedJavaType adapter = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.SqlProviderAdapter");
        FullyQualifiedJavaType annotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.InsertProvider");
        imports.add(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.insert.render.InsertStatementProvider"));
        imports.add(adapter);
        imports.add(annotation);
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.insert.render.InsertStatementProvider");
        imports.add(recordType);
        parameterType.addTypeArgument(recordType);
        Method method = new Method("insert");
        method.setAbstract(true);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        method.addParameter(new Parameter(parameterType, "insertStatement"));
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, imports);
        method.addAnnotation("@InsertProvider(type=SqlProviderAdapter.class, method=\"insert\")");
        MethodAndImports.Builder builder = MethodAndImports.withMethod((Method)method).withImports(imports);
        introspectedTable.getPrimaryKeyColumns().stream().filter(IntrospectedColumn::isAutoIncrement).findFirst().ifPresent(introspectedColumn -> {
            FullyQualifiedJavaType importOptionType = new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options");
            if (!interfaze.getImportedTypes().contains(importOptionType)) {
                interfaze.addImportedType(importOptionType);
            }
            String optionsAnnotation = "@Options(useGeneratedKeys = true,keyProperty = \"row." + introspectedColumn.getJavaProperty() + "\",keyColumn = \"" + introspectedColumn.getActualColumnName() + "\")";
            method.addAnnotation(optionsAnnotation);
        });
        MethodAndImports methodAndImports = builder.build();
        interfaze.addImportedTypes(methodAndImports.getImports());
        interfaze.getMethods().add(0, methodAndImports.getMethod());
    }

    public boolean clientBasicSelectManyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Flux<" + introspectedTable.getBaseRecordType() + ">"));
        return true;
    }

    public boolean clientBasicSelectOneMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<" + introspectedTable.getBaseRecordType() + ">"));
        return true;
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientGeneralDeleteMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientGeneralCountMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Long>"));
        return true;
    }

    public boolean clientGeneralSelectDistinctMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Flux<" + introspectedTable.getBaseRecordType() + ">"));
        return true;
    }

    public boolean clientGeneralSelectMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Flux<" + introspectedTable.getBaseRecordType() + ">"));
        return true;
    }

    public boolean clientSelectOneMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<" + introspectedTable.getBaseRecordType() + ">"));
        return true;
    }

    public boolean clientGeneralUpdateMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientInsertMultipleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.replaceMyBatis3UtilsLine(method);
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    private void replaceMyBatis3UtilsLine(Method method) {
        List bodyLines = method.getBodyLines();
        Optional<String> optionalReplacedValue = bodyLines.stream().findFirst().map(value -> StringUtils.replace((String)value, (String)"MyBatis3Utils", (String)"ReactiveMyBatis3Utils"));
        if (optionalReplacedValue.isPresent()) {
            bodyLines.remove(0);
            bodyLines.add(0, optionalReplacedValue.get());
        }
    }

    public boolean clientSelectAllMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        interfaze.addStaticImport("org.mybatis.dynamic.sql.SqlBuilder.isEqualTo");
        FullyQualifiedJavaType whereApplierType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.where.WhereApplier");
        interfaze.addImportedType(whereApplierType);
        method.setName("updateSelective");
        method.addParameter(new Parameter(whereApplierType, "whereApplier"));
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        String resultMapId = recordType.getShortNameWithoutTypeArguments() + "Result";
        String tableFieldName = JavaBeansUtil.getValidPropertyName((String)introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        FragmentGenerator fragmentGenerator = new FragmentGenerator.Builder().withIntrospectedTable(introspectedTable).withResultMapId(resultMapId).withTableFieldName(tableFieldName).build();
        method.getBodyLines().clear();
        method.addBodyLine("return update(c ->");
        method.addBodyLines((Collection)fragmentGenerator.getSetEqualWhenPresentLines(introspectedTable.getNonPrimaryKeyColumns(), "    c", "    ", false));
        method.addBodyLine("    .applyWhere(whereApplier)");
        method.addBodyLine(");");
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientUpdateSelectiveColumnsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        method.setStatic(false);
        method.setDefault(true);
        List bodyLines = method.getBodyLines();
        String tableFieldName = JavaBeansUtil.getValidPropertyName((String)introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        bodyLines.clear();
        List<String> lines = this.getUpdateByPrimaryKeyBodyLineWithAllNonPrimaryKeyColumns(tableFieldName, introspectedTable);
        bodyLines.addAll(lines);
        method.getParameters().removeIf(parameter -> StringUtils.equals((CharSequence)parameter.getType().getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL<org.mybatis.dynamic.sql.update.UpdateModel>"));
        interfaze.getImportedTypes().removeIf(parameter -> StringUtils.equals((CharSequence)parameter.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL"));
        method.setName("updateAllByPrimaryKey");
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientUpdateAllColumnsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        method.setStatic(false);
        method.setDefault(true);
        List bodyLines = method.getBodyLines();
        String tableFieldName = JavaBeansUtil.getValidPropertyName((String)introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        bodyLines.clear();
        List<String> lines = this.getUpdateSelectiveByPrimaryKeyBodyLineWithAllNonPrimaryKeyColumns(tableFieldName, introspectedTable);
        bodyLines.addAll(lines);
        method.getParameters().removeIf(parameter -> StringUtils.equals((CharSequence)parameter.getType().getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL<org.mybatis.dynamic.sql.update.UpdateModel>"));
        interfaze.getImportedTypes().removeIf(parameter -> StringUtils.equals((CharSequence)parameter.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL"));
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        method.setName("updateSelectiveByPrimaryKey");
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        method.setStatic(false);
        method.setDefault(true);
        List bodyLines = method.getBodyLines();
        String tableFieldName = JavaBeansUtil.getValidPropertyName((String)introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        bodyLines.clear();
        List<String> lines = this.getUpdateWhereApplierBodyLineWithAllNonPrimaryKeyColumns(tableFieldName, introspectedTable);
        bodyLines.addAll(lines);
        FullyQualifiedJavaType whereApplierType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.where.WhereApplier");
        method.getParameters().removeIf(parameter -> StringUtils.equals((CharSequence)parameter.getType().getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL<org.mybatis.dynamic.sql.update.UpdateModel>"));
        interfaze.getImportedTypes().removeIf(parameter -> StringUtils.equals((CharSequence)parameter.getFullyQualifiedName(), (CharSequence)"org.mybatis.dynamic.sql.update.UpdateDSL"));
        interfaze.addImportedType(whereApplierType);
        method.setName("updateAll");
        method.addParameter(new Parameter(whereApplierType, "whereApplier"));
        method.setReturnType(new FullyQualifiedJavaType("reactor.core.publisher.Mono<java.lang.Integer>"));
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List elements = document.getRootElement().getElements();
        XmlElement xmlElement = (XmlElement)elements.get(0);
        List elementElements = xmlElement.getElements();
        elementElements.removeIf(visitableElement -> visitableElement instanceof TextElement);
        String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        XmlElement newXmlElement = new XmlElement(xmlElement);
        List<Attribute> attributeList = newXmlElement.getAttributes().stream().map(attribute -> {
            if ("id".equals(attribute.getName())) {
                return new Attribute(attribute.getName(), "TableResultMap");
            }
            return new Attribute(attribute.getName(), attribute.getValue());
        }).collect(Collectors.toList());
        newXmlElement.getAttributes().clear();
        attributeList.forEach(arg_0 -> ((XmlElement)newXmlElement).addAttribute(arg_0));
        ArrayList columnNameWithTable = new ArrayList();
        List<XmlElement> subXmlElements = newXmlElement.getElements().stream().map(element -> {
            XmlElement subXmlElement = new XmlElement((XmlElement)element);
            List<Attribute> attributes = subXmlElement.getAttributes().stream().map(attribute -> {
                if ("column".equals(attribute.getName())) {
                    String columnWithTableName = tableName + "_" + attribute.getValue();
                    columnNameWithTable.add(tableName + "." + attribute.getValue() + " AS " + columnWithTableName);
                    return new Attribute(attribute.getName(), columnWithTableName);
                }
                return new Attribute(attribute.getName(), attribute.getValue());
            }).collect(Collectors.toList());
            subXmlElement.getAttributes().clear();
            attributes.forEach(arg_0 -> ((XmlElement)subXmlElement).addAttribute(arg_0));
            return subXmlElement;
        }).collect(Collectors.toList());
        newXmlElement.getElements().clear();
        subXmlElements.forEach(arg_0 -> ((XmlElement)newXmlElement).addElement(arg_0));
        elements.add(newXmlElement);
        XmlElement columnSqlXmlElement = new XmlElement("sql");
        columnSqlXmlElement.addAttribute(new Attribute("id", "columnNameWithTable"));
        String columnNameWithTableSql = String.join((CharSequence)", \n    ", columnNameWithTable);
        TextElement columnSqlContentElement = new TextElement(columnNameWithTableSql);
        columnSqlXmlElement.addElement((VisitableElement)columnSqlContentElement);
        elements.add(columnSqlXmlElement);
        return true;
    }

    public boolean sqlMapDeleteByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectAllElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerApplyWhereMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerInsertSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerUpdateByPrimaryKeySelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!this.autoGenerateModel) {
            return false;
        }
        this.generatedModelCustomizer.customizeLombok(topLevelClass, introspectedTable);
        this.generatedModelCustomizer.customizeModelConstant(this.context, topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!this.autoGenerateModel) {
            return false;
        }
        this.generatedModelCustomizer.customizeLombok(topLevelClass, introspectedTable);
        this.generatedModelCustomizer.customizeModelConstant(this.context, topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (!this.autoGenerateModel) {
            return false;
        }
        this.generatedModelCustomizer.customizeLombok(topLevelClass, introspectedTable);
        this.generatedModelCustomizer.customizeModelConstant(this.context, topLevelClass, introspectedTable);
        return false;
    }

    public boolean dynamicSqlSupportGenerated(TopLevelClass supportClass, IntrospectedTable introspectedTable) {
        String tableRemarks = (String)StringUtils.defaultIfBlank((CharSequence)introspectedTable.getRemarks(), (CharSequence)"auto generated");
        supportClass.addJavaDocLine("/**");
        supportClass.addJavaDocLine(" * " + tableRemarks + " dynamic mapper");
        supportClass.addJavaDocLine(" * ");
        supportClass.addJavaDocLine(" * @author autoGenerated");
        supportClass.addJavaDocLine(" */");
        return true;
    }

    private List<String> getUpdateWhereApplierBodyLineWithAllNonPrimaryKeyColumns(String tableFieldName, IntrospectedTable introspectedTable) {
        ArrayList<String> lines = new ArrayList<String>();
        List columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns((List)introspectedTable.getNonPrimaryKeyColumns());
        Iterator iter = columns.iterator();
        boolean first = true;
        String firstLinePrefix = "    c";
        String subsequentLinePrefix = "    ";
        lines.add("return update(c ->");
        while (iter.hasNext()) {
            String start;
            IntrospectedColumn column = (IntrospectedColumn)iter.next();
            String fieldName = AbstractMethodGenerator.calculateFieldName((String)tableFieldName, (IntrospectedColumn)column);
            String methodName = JavaBeansUtil.getGetterMethodName((String)column.getJavaProperty(), (FullyQualifiedJavaType)column.getFullyQualifiedJavaType());
            if (first) {
                start = firstLinePrefix;
                first = false;
            } else {
                start = subsequentLinePrefix;
            }
            String line = null;
            line = column.isNullable() ? start + ".set(" + fieldName + ").equalTo(row::" + methodName + ")" : start + ".set(" + fieldName + ").equalToWhenPresent(row::" + methodName + ")";
            lines.add(line);
        }
        lines.add(subsequentLinePrefix + ".applyWhere(whereApplier)");
        lines.add(");");
        return lines;
    }

    private List<String> getUpdateByPrimaryKeyBodyLineWithAllNonPrimaryKeyColumns(String tableFieldName, IntrospectedTable introspectedTable) {
        ArrayList<String> lines = new ArrayList<String>();
        List columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns((List)introspectedTable.getNonPrimaryKeyColumns());
        Iterator iter = columns.iterator();
        boolean first = true;
        String firstLinePrefix = "    c";
        String subsequentLinePrefix = "    ";
        lines.add("return update(c ->");
        while (iter.hasNext()) {
            String start;
            IntrospectedColumn column = (IntrospectedColumn)iter.next();
            String fieldName = AbstractMethodGenerator.calculateFieldName((String)tableFieldName, (IntrospectedColumn)column);
            String methodName = JavaBeansUtil.getGetterMethodName((String)column.getJavaProperty(), (FullyQualifiedJavaType)column.getFullyQualifiedJavaType());
            if (first) {
                start = firstLinePrefix;
                first = false;
            } else {
                start = subsequentLinePrefix;
            }
            String line = null;
            line = column.isNullable() ? start + ".set(" + fieldName + ").equalTo(row::" + methodName + ")" : start + ".set(" + fieldName + ").equalToWhenPresent(row::" + methodName + ")";
            lines.add(line);
        }
        first = true;
        for (IntrospectedColumn column : introspectedTable.getPrimaryKeyColumns()) {
            String fieldName = AbstractMethodGenerator.calculateFieldName((String)tableFieldName, (IntrospectedColumn)column);
            String methodName = JavaBeansUtil.getGetterMethodName((String)column.getJavaProperty(), (FullyQualifiedJavaType)column.getFullyQualifiedJavaType());
            if (first) {
                lines.add(subsequentLinePrefix + ".where(" + fieldName + ", isEqualTo(row::" + methodName + "))");
                first = false;
                continue;
            }
            lines.add(subsequentLinePrefix + ".and(" + fieldName + ", isEqualTo(row::" + methodName + "))");
        }
        lines.add(");");
        return lines;
    }

    private List<String> getUpdateSelectiveByPrimaryKeyBodyLineWithAllNonPrimaryKeyColumns(String tableFieldName, IntrospectedTable introspectedTable) {
        ArrayList<String> lines = new ArrayList<String>();
        List columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns((List)introspectedTable.getNonPrimaryKeyColumns());
        Iterator iter = columns.iterator();
        boolean first = true;
        String firstLinePrefix = "    c";
        String subsequentLinePrefix = "    ";
        lines.add("return update(c ->");
        while (iter.hasNext()) {
            String start;
            IntrospectedColumn column = (IntrospectedColumn)iter.next();
            String fieldName = AbstractMethodGenerator.calculateFieldName((String)tableFieldName, (IntrospectedColumn)column);
            String methodName = JavaBeansUtil.getGetterMethodName((String)column.getJavaProperty(), (FullyQualifiedJavaType)column.getFullyQualifiedJavaType());
            if (first) {
                start = firstLinePrefix;
                first = false;
            } else {
                start = subsequentLinePrefix;
            }
            String line = start + ".set(" + fieldName + ").equalToWhenPresent(row::" + methodName + ")";
            lines.add(line);
        }
        first = true;
        for (IntrospectedColumn column : introspectedTable.getPrimaryKeyColumns()) {
            String fieldName = AbstractMethodGenerator.calculateFieldName((String)tableFieldName, (IntrospectedColumn)column);
            String methodName = JavaBeansUtil.getGetterMethodName((String)column.getJavaProperty(), (FullyQualifiedJavaType)column.getFullyQualifiedJavaType());
            if (first) {
                lines.add(subsequentLinePrefix + ".where(" + fieldName + ", isEqualTo(row::" + methodName + "))");
                first = false;
                continue;
            }
            lines.add(subsequentLinePrefix + ".and(" + fieldName + ", isEqualTo(row::" + methodName + "))");
        }
        lines.add(");");
        return lines;
    }
}

