/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.plugin.other;

import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class TrimTableNamePlugin
extends PluginAdapter {
    private String prefix;

    public boolean validate(List<String> warnings) {
        String trimPrefix = this.properties.getProperty("tablePrefix");
        boolean valid = StringUtility.stringHasValue((String)trimPrefix);
        if (valid) {
            this.prefix = this.upperFirstLetter(trimPrefix);
        } else if (!StringUtility.stringHasValue((String)trimPrefix)) {
            warnings.add(Messages.getString((String)"ValidationError.18", (String)"TrimTableNamePlugin", (String)"trimPrefix"));
        }
        return valid;
    }

    public void initialized(IntrospectedTable introspectedTable) {
        introspectedTable.setMyBatis3JavaMapperType(this.trimPrefix(introspectedTable.getMyBatis3JavaMapperType()));
        introspectedTable.setMyBatisDynamicSqlSupportType(this.trimPrefix(introspectedTable.getMyBatisDynamicSqlSupportType()));
        introspectedTable.setMyBatis3XmlMapperFileName(this.trimPrefix(introspectedTable.getMyBatis3XmlMapperFileName()));
    }

    private String trimPrefix(String name) {
        CharSequence[] split = name.split("\\.");
        if (split.length == 0) {
            return name;
        }
        String last = split[split.length - 1];
        if (!StringUtility.stringHasValue((String)last)) {
            return name;
        }
        if (!last.startsWith(this.prefix)) {
            return name;
        }
        split[split.length - 1] = last = last.replaceFirst(this.prefix, "");
        return String.join((CharSequence)".", split);
    }

    private String upperFirstLetter(String letter) {
        char[] chars = letter.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }
}

