/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.core.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.ContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.impl.MyBatisSimpleContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.impl.MyBatisSimpleModelContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.impl.MyBatisSimpleModelXmlContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.impl.MybatisDynamicContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.impl.MybatisDynamicMapperContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.option.GeneratorType;

public class ContextGeneratorFactory {
    private final Map<GeneratorType, ContextGenerator> contextGeneratorContainer = new HashMap<GeneratorType, ContextGenerator>();

    public ContextGeneratorFactory() {
        this.registerContextGenerator(new MyBatisSimpleContextGenerator());
        this.registerContextGenerator(new MybatisDynamicContextGenerator());
        this.registerContextGenerator(new MyBatisSimpleModelContextGenerator());
        this.registerContextGenerator(new MyBatisSimpleModelXmlContextGenerator());
        this.registerContextGenerator(new MybatisDynamicMapperContextGenerator());
    }

    public void registerContextGenerator(ContextGenerator contextGenerator) {
        this.contextGeneratorContainer.put(contextGenerator.targetGeneratorType(), contextGenerator);
    }

    public Optional<ContextGenerator> getContextGenerator(GeneratorType generatorType) {
        return Optional.ofNullable(this.contextGeneratorContainer.get((Object)generatorType));
    }
}

