/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.plugin.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import pro.chenggang.project.reactive.mybatis.support.generator.support.GeneratedModelCustomizer;

public class CustomGeneratorPlugin
extends PluginAdapter {
    private final GeneratedModelCustomizer generatedModelCustomizer = new GeneratedModelCustomizer();
    private boolean extendDynamicMapper;

    public boolean validate(List<String> warnings) {
        this.extendDynamicMapper = Boolean.parseBoolean(this.properties.getProperty("extendDynamicMapper"));
        return true;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
            interfaze.addAnnotation("@Mapper");
            boolean hasDynamicSqlInClasspath = false;
            try {
                Class<?> aClass = Class.forName("org.mybatis.dynamic.sql.SqlBuilder");
                hasDynamicSqlInClasspath = true;
            }
            catch (ClassNotFoundException aClass) {
                // empty catch block
            }
            if (this.extendDynamicMapper && hasDynamicSqlInClasspath) {
                String fullyQualifiedName = interfaze.getType().getFullyQualifiedName();
                String beforeLast = StringUtils.substringBeforeLast((String)fullyQualifiedName, (String)"Mapper");
                String dynamicMapperName = beforeLast + "DynamicMapper";
                String importDynamicMapperName = interfaze.getType().getPackageName() + ".dynamic." + StringUtils.substringAfterLast((String)dynamicMapperName, (String)".");
                interfaze.addImportedType(new FullyQualifiedJavaType(importDynamicMapperName));
                interfaze.addSuperInterface(new FullyQualifiedJavaType(dynamicMapperName));
            }
        }
        String tableRemarks = (String)StringUtils.defaultIfBlank((CharSequence)introspectedTable.getRemarks(), (CharSequence)"auto generated");
        interfaze.addJavaDocLine("/**");
        interfaze.addJavaDocLine(" * " + tableRemarks + " mapper");
        interfaze.addJavaDocLine(" * ");
        interfaze.addJavaDocLine(" * @author autoGenerated");
        interfaze.addJavaDocLine(" */");
        return true;
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectAllMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List elements = document.getRootElement().getElements();
        XmlElement xmlElement = (XmlElement)elements.get(0);
        List elementElements = xmlElement.getElements();
        elementElements.removeIf(visitableElement -> visitableElement instanceof TextElement);
        String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        XmlElement newXmlElement = new XmlElement(xmlElement);
        List<Attribute> attributeList = newXmlElement.getAttributes().stream().map(attribute -> {
            if ("id".equals(attribute.getName())) {
                return new Attribute(attribute.getName(), "TableResultMap");
            }
            return new Attribute(attribute.getName(), attribute.getValue());
        }).collect(Collectors.toList());
        newXmlElement.getAttributes().clear();
        attributeList.forEach(arg_0 -> ((XmlElement)newXmlElement).addAttribute(arg_0));
        ArrayList columnNameWithTable = new ArrayList();
        List<XmlElement> subXmlElements = newXmlElement.getElements().stream().map(element -> {
            XmlElement subXmlElement = new XmlElement((XmlElement)element);
            List<Attribute> attributes = subXmlElement.getAttributes().stream().map(attribute -> {
                if ("column".equals(attribute.getName())) {
                    String columnWithTableName = tableName + "_" + attribute.getValue();
                    columnNameWithTable.add(tableName + "." + attribute.getValue() + " AS " + columnWithTableName);
                    return new Attribute(attribute.getName(), columnWithTableName);
                }
                return new Attribute(attribute.getName(), attribute.getValue());
            }).collect(Collectors.toList());
            subXmlElement.getAttributes().clear();
            attributes.forEach(arg_0 -> ((XmlElement)subXmlElement).addAttribute(arg_0));
            return subXmlElement;
        }).collect(Collectors.toList());
        newXmlElement.getElements().clear();
        subXmlElements.forEach(arg_0 -> ((XmlElement)newXmlElement).addElement(arg_0));
        elements.add(newXmlElement);
        XmlElement columnSqlXmlElement = new XmlElement("sql");
        columnSqlXmlElement.addAttribute(new Attribute("id", "columnNameWithTable"));
        String columnNameWithTableSql = String.join((CharSequence)", \n    ", columnNameWithTable);
        TextElement columnSqlContentElement = new TextElement(columnNameWithTableSql);
        columnSqlXmlElement.addElement((VisitableElement)columnSqlContentElement);
        elements.add(columnSqlXmlElement);
        return true;
    }

    public boolean sqlMapDeleteByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectAllElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerApplyWhereMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerInsertSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean providerUpdateByPrimaryKeySelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatedModelCustomizer.customizeLombok(topLevelClass, introspectedTable);
        this.generatedModelCustomizer.customizeModelConstant(this.context, topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatedModelCustomizer.customizeLombok(topLevelClass, introspectedTable);
        this.generatedModelCustomizer.customizeModelConstant(this.context, topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatedModelCustomizer.customizeLombok(topLevelClass, introspectedTable);
        this.generatedModelCustomizer.customizeModelConstant(this.context, topLevelClass, introspectedTable);
        return false;
    }
}

