/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.properties;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorProperties;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesLoader;

public class GeneratorPropertiesHolder {
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private GeneratorProperties generatorProperties;
    private GeneratorPropertiesLoader generatorPropertiesLoader;

    public static GeneratorPropertiesHolder getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public GeneratorProperties getGeneratorProperties() {
        return this.getGeneratorPropertiesInternal().orElseGet(this::loadGeneratorProperties);
    }

    public void setGeneratorPropertiesLoader(GeneratorPropertiesLoader generatorPropertiesLoader) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.generatorPropertiesLoader = generatorPropertiesLoader;
            this.generatorProperties = null;
        }
        finally {
            writeLock.unlock();
        }
    }

    private Optional<GeneratorProperties> getGeneratorPropertiesInternal() {
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Optional<GeneratorProperties> optional = Optional.ofNullable(this.generatorProperties);
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    private GeneratorProperties loadGeneratorProperties() {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (Objects.nonNull(this.generatorProperties)) {
                GeneratorProperties generatorProperties = this.generatorProperties;
                return generatorProperties;
            }
            if (Objects.isNull(this.generatorPropertiesLoader)) {
                throw new IllegalStateException("Generator properties loader is null, can not load properties");
            }
            this.generatorProperties = this.generatorPropertiesLoader.load();
            if (Objects.isNull(this.generatorProperties)) {
                throw new IllegalStateException("Generator properties is null after load from " + this.generatorPropertiesLoader.getClass().getName());
            }
            GeneratorProperties generatorProperties = this.generatorProperties;
            return generatorProperties;
        }
        finally {
            writeLock.unlock();
        }
    }

    private GeneratorPropertiesHolder() {
    }

    private static class InstanceHolder {
        private static final GeneratorPropertiesHolder INSTANCE = new GeneratorPropertiesHolder();

        private InstanceHolder() {
        }
    }
}

