/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import pro.chenggang.project.reactive.mybatis.support.generator.core.MybatisDynamicCodeGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.option.GeneratorType;
import pro.chenggang.project.reactive.mybatis.support.generator.option.LombokConfig;
import pro.chenggang.project.reactive.mybatis.support.generator.plugin.type.GeneratedJavaTypeModifier;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.FluentGeneratorPropertiesLoader;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorProperties;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesHolder;

public class GeneratorPropertiesBuilder {
    private final MybatisDynamicCodeGenerator.Configurer configurer;
    private Set<GeneratorType> generatorTypes = new HashSet<GeneratorType>();
    private boolean extendDynamicMapper = true;
    private boolean overwrite = false;
    private boolean generateReturnedKey = false;
    private boolean generateComment = true;
    private String tableNameTrimPattern;
    private String columnNameTrimPattern;
    private Class<? extends GeneratedJavaTypeModifier> defaultJavaTypeModifierClass;
    private Set<LombokConfig> lombokConfigs = new HashSet<LombokConfig>();
    private Set<String> tableNames;
    private GeneratorProperties.TargetLocation targetLocation;
    private GeneratorProperties.TargetPackage targetPackage;
    private GeneratorProperties.TargetConnection targetConnection;

    protected GeneratorPropertiesBuilder(MybatisDynamicCodeGenerator.Configurer configurer) {
        this.configurer = configurer;
    }

    public GeneratorPropertiesBuilder(GeneratorProperties generatorProperties, MybatisDynamicCodeGenerator.Configurer configurer) {
        this.configurer = configurer;
        this.generatorTypes = generatorProperties.getGeneratorTypes();
        this.extendDynamicMapper = generatorProperties.isExtendDynamicMapper();
        this.overwrite = generatorProperties.isOverwrite();
        this.generateReturnedKey = generatorProperties.isGenerateReturnedKey();
        this.generateComment = generatorProperties.isGenerateComment();
        this.tableNameTrimPattern = generatorProperties.getTableNameTrimPattern();
        this.columnNameTrimPattern = generatorProperties.getColumnNameTrimPattern();
        this.defaultJavaTypeModifierClass = generatorProperties.getDefaultJavaTypeModifierClass();
        this.lombokConfigs = generatorProperties.getLombokConfigs();
        this.tableNames = generatorProperties.getTableNames();
        this.targetLocation = generatorProperties.getTargetLocation();
        this.targetPackage = generatorProperties.getTargetPackage();
        this.targetConnection = generatorProperties.getTargetConnection();
    }

    public GeneratorPropertiesBuilder generatorTypes(GeneratorType ... generatorTypes) {
        this.generatorTypes.addAll(Arrays.asList(generatorTypes));
        return this;
    }

    public GeneratorPropertiesBuilder generatorTypes(Set<GeneratorType> generatorTypes) {
        this.generatorTypes = generatorTypes;
        return this;
    }

    public GeneratorPropertiesBuilder extendDynamicMapper(boolean extendDynamicMapper) {
        this.extendDynamicMapper = extendDynamicMapper;
        return this;
    }

    public GeneratorPropertiesBuilder overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public GeneratorPropertiesBuilder generateReturnedKey(boolean generateReturnedKey) {
        this.generateReturnedKey = generateReturnedKey;
        return this;
    }

    public GeneratorPropertiesBuilder generateComment(boolean generateComment) {
        this.generateComment = generateComment;
        return this;
    }

    public GeneratorPropertiesBuilder tableNameTrimPattern(String tableNameTrimPattern) {
        this.tableNameTrimPattern = tableNameTrimPattern;
        return this;
    }

    public GeneratorPropertiesBuilder columnNameTrimPattern(String columnNameTrimPattern) {
        this.columnNameTrimPattern = columnNameTrimPattern;
        return this;
    }

    public GeneratorPropertiesBuilder defaultJavaTypeModifierClass(Class<? extends GeneratedJavaTypeModifier> defaultJavaTypeModifierClass) {
        this.defaultJavaTypeModifierClass = defaultJavaTypeModifierClass;
        return this;
    }

    public GeneratorPropertiesBuilder lombokConfigs(LombokConfig ... lombokConfigs) {
        this.lombokConfigs.addAll(Arrays.asList(lombokConfigs));
        return this;
    }

    public GeneratorPropertiesBuilder lombokConfigs(Set<LombokConfig> lombokConfigs) {
        this.lombokConfigs = lombokConfigs;
        return this;
    }

    public GeneratorPropertiesBuilder tableNames(String ... tableNames) {
        this.tableNames.addAll(Arrays.asList(tableNames));
        return this;
    }

    public GeneratorPropertiesBuilder tableNames(Set<String> tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    public TargetLocationBuilder targetLocationBuilder() {
        return new TargetLocationBuilder(this);
    }

    public TargetPackageBuilder targetPackageBuilder() {
        return new TargetPackageBuilder(this);
    }

    public TargetConnectionBuilder targetConnectionBuilder() {
        return new TargetConnectionBuilder(this);
    }

    protected GeneratorProperties build() {
        return new GeneratorProperties(this.generatorTypes, this.extendDynamicMapper, this.overwrite, this.generateReturnedKey, this.generateComment, this.tableNameTrimPattern, this.columnNameTrimPattern, this.defaultJavaTypeModifierClass, this.targetLocation, this.targetPackage, this.targetConnection, this.lombokConfigs, this.tableNames);
    }

    public MybatisDynamicCodeGenerator.Configurer thenConfigurer() {
        GeneratorPropertiesHolder.getInstance().setGeneratorPropertiesLoader(new FluentGeneratorPropertiesLoader(this));
        return this.configurer;
    }

    public static class TargetConnectionBuilder {
        private final GeneratorPropertiesBuilder generatorPropertiesBuilder;
        private String jdbcDriverClassName;
        private String jdbcConnectionUrl;
        private String username;
        private String password;

        private TargetConnectionBuilder(GeneratorPropertiesBuilder generatorPropertiesBuilder) {
            this.generatorPropertiesBuilder = generatorPropertiesBuilder;
            GeneratorProperties.TargetConnection targetConnection = generatorPropertiesBuilder.targetConnection;
            if (Objects.nonNull(targetConnection)) {
                this.jdbcDriverClassName = targetConnection.getJdbcDriverClassName();
                this.jdbcConnectionUrl = targetConnection.getJdbcConnectionUrl();
                this.username = targetConnection.getUsername();
                this.password = targetConnection.getPassword();
            }
        }

        public TargetConnectionBuilder jdbcDriverClassName(String jdbcDriverClassName) {
            this.jdbcDriverClassName = jdbcDriverClassName;
            return this;
        }

        public TargetConnectionBuilder jdbcConnectionUrl(String jdbcConnectionUrl) {
            this.jdbcConnectionUrl = jdbcConnectionUrl;
            return this;
        }

        public TargetConnectionBuilder username(String username) {
            this.username = username;
            return this;
        }

        public TargetConnectionBuilder password(String password) {
            this.password = password;
            return this;
        }

        public GeneratorPropertiesBuilder thenBuilder() {
            this.generatorPropertiesBuilder.targetConnection = new GeneratorProperties.TargetConnection(this.jdbcDriverClassName, this.jdbcConnectionUrl, this.username, this.password);
            return this.generatorPropertiesBuilder;
        }
    }

    public static class TargetPackageBuilder {
        private final GeneratorPropertiesBuilder generatorPropertiesBuilder;
        private String basePackage;
        private String modelPackage;
        private String mapperInterfacePackage;
        private String mapperXmlPackage;

        private TargetPackageBuilder(GeneratorPropertiesBuilder generatorPropertiesBuilder) {
            this.generatorPropertiesBuilder = generatorPropertiesBuilder;
            GeneratorProperties.TargetPackage targetPackage = generatorPropertiesBuilder.targetPackage;
            if (Objects.nonNull(targetPackage)) {
                this.basePackage = targetPackage.getBasePackage();
                this.modelPackage = targetPackage.getModelPackage();
                this.mapperInterfacePackage = targetPackage.getMapperInterfacePackage();
                this.mapperXmlPackage = targetPackage.getMapperXmlPackage();
            }
        }

        public TargetPackageBuilder basePackage(String basePackage) {
            this.basePackage = basePackage;
            return this;
        }

        public TargetPackageBuilder modelPackage(String modelPackage) {
            this.modelPackage = modelPackage;
            return this;
        }

        public TargetPackageBuilder mapperInterfacePackage(String mapperInterfacePackage) {
            this.mapperInterfacePackage = mapperInterfacePackage;
            return this;
        }

        public TargetPackageBuilder mapperXmlPackage(String mapperXmlPackage) {
            this.mapperXmlPackage = mapperXmlPackage;
            return this;
        }

        public GeneratorPropertiesBuilder thenPropertiesBuilder() {
            this.generatorPropertiesBuilder.targetPackage = new GeneratorProperties.TargetPackage(this.basePackage, this.modelPackage, this.mapperInterfacePackage, this.mapperXmlPackage);
            return this.generatorPropertiesBuilder;
        }
    }

    public static class TargetLocationBuilder {
        private final GeneratorPropertiesBuilder generatorPropertiesBuilder;
        private String baseLocation;
        private String javaLocation = "src/main/java";
        private String mapperXmlLocation = "src/main/resources";

        private TargetLocationBuilder(GeneratorPropertiesBuilder generatorPropertiesBuilder) {
            this.generatorPropertiesBuilder = generatorPropertiesBuilder;
            GeneratorProperties.TargetLocation targetLocation = generatorPropertiesBuilder.targetLocation;
            if (Objects.nonNull(targetLocation)) {
                this.baseLocation = targetLocation.getBaseLocation();
                this.javaLocation = targetLocation.getJavaLocation();
                this.mapperXmlLocation = targetLocation.getMapperXmlLocation();
            }
        }

        public TargetLocationBuilder baseLocation(String baseLocation) {
            this.baseLocation = baseLocation;
            return this;
        }

        public TargetLocationBuilder javaLocation(String javaLocation) {
            this.javaLocation = javaLocation;
            return this;
        }

        public TargetLocationBuilder mapperXmlLocation(String mapperXmlLocation) {
            this.mapperXmlLocation = mapperXmlLocation;
            return this;
        }

        public GeneratorPropertiesBuilder thenBuilder() {
            this.generatorPropertiesBuilder.targetLocation = new GeneratorProperties.TargetLocation(this.baseLocation, this.javaLocation, this.mapperXmlLocation);
            return this.generatorPropertiesBuilder;
        }
    }
}

