/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.properties;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import pro.chenggang.project.reactive.mybatis.support.generator.option.GeneratorType;
import pro.chenggang.project.reactive.mybatis.support.generator.option.LombokConfig;
import pro.chenggang.project.reactive.mybatis.support.generator.plugin.type.GeneratedJavaTypeModifier;

public class GeneratorProperties {
    private Set<GeneratorType> generatorTypes;
    private boolean extendDynamicMapper = true;
    private boolean overwrite = false;
    private boolean generateReturnedKey = false;
    private boolean generateComment = true;
    private String tableNameTrimPattern;
    private String columnNameTrimPattern;
    private Class<? extends GeneratedJavaTypeModifier> defaultJavaTypeModifierClass;
    private TargetLocation targetLocation;
    private TargetPackage targetPackage;
    private TargetConnection targetConnection;
    private Set<LombokConfig> lombokConfigs;
    private Set<String> tableNames;

    public void validate() {
        if (Objects.isNull(this.generatorTypes) || this.generatorTypes.isEmpty()) {
            throw new IllegalArgumentException("Generator types should be configured");
        }
        Objects.requireNonNull(this.targetLocation, () -> "Target location should be configured");
        Objects.requireNonNull(this.targetPackage, () -> "Target package should be configured");
        Objects.requireNonNull(this.targetConnection, () -> "Target connection should be configured");
        this.requiredNotBlank(this.targetLocation.javaLocation, () -> "Java location should be configured");
        this.requiredNotBlank(this.targetLocation.getJavaLocation(), () -> "Java location should be configured");
        this.requiredNotBlank(this.targetLocation.getMapperXmlLocation(), () -> "Mapper xml location should be configured");
        this.requiredNotBlank(this.targetPackage.getModelPackage(), () -> "Model package should be configured");
        this.requiredNotBlank(this.targetPackage.getMapperInterfacePackage(), () -> "Mapper interface package should be configured");
        this.requiredNotBlank(this.targetPackage.getMapperXmlPackage(), () -> "Mapper xml package should be configured");
        this.requiredNotBlank(this.targetConnection.getJdbcConnectionUrl(), () -> "JDBC connection URL should be configured");
        this.requiredNotBlank(this.targetConnection.getJdbcDriverClassName(), () -> "JDBC driver class name should be configured");
        this.requiredNotBlank(this.targetConnection.getPassword(), () -> "JDBC password should be configured");
        this.requiredNotBlank(this.targetConnection.getUsername(), () -> "JDBC username should be configured");
        if (this.generatorTypes.contains((Object)GeneratorType.DYNAMIC)) {
            this.generatorTypes.remove((Object)GeneratorType.MODEL);
            this.generatorTypes.remove((Object)GeneratorType.MODEL_XML);
            this.generatorTypes.remove((Object)GeneratorType.DYNAMIC_MAPPER);
        }
        if (this.generatorTypes.contains((Object)GeneratorType.SIMPLE)) {
            this.generatorTypes.remove((Object)GeneratorType.MODEL);
            this.generatorTypes.remove((Object)GeneratorType.MODEL_XML);
        }
    }

    private void requiredNotBlank(String value, Supplier<String> errorMessageSupplier) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessageSupplier.get());
        }
    }

    public Set<GeneratorType> getGeneratorTypes() {
        return this.generatorTypes;
    }

    public boolean isExtendDynamicMapper() {
        return this.extendDynamicMapper;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isGenerateReturnedKey() {
        return this.generateReturnedKey;
    }

    public boolean isGenerateComment() {
        return this.generateComment;
    }

    public String getTableNameTrimPattern() {
        return this.tableNameTrimPattern;
    }

    public String getColumnNameTrimPattern() {
        return this.columnNameTrimPattern;
    }

    public Class<? extends GeneratedJavaTypeModifier> getDefaultJavaTypeModifierClass() {
        return this.defaultJavaTypeModifierClass;
    }

    public TargetLocation getTargetLocation() {
        return this.targetLocation;
    }

    public TargetPackage getTargetPackage() {
        return this.targetPackage;
    }

    public TargetConnection getTargetConnection() {
        return this.targetConnection;
    }

    public Set<LombokConfig> getLombokConfigs() {
        return this.lombokConfigs;
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public String toString() {
        return "GeneratorProperties(generatorTypes=" + this.getGeneratorTypes() + ", extendDynamicMapper=" + this.isExtendDynamicMapper() + ", overwrite=" + this.isOverwrite() + ", generateReturnedKey=" + this.isGenerateReturnedKey() + ", generateComment=" + this.isGenerateComment() + ", tableNameTrimPattern=" + this.getTableNameTrimPattern() + ", columnNameTrimPattern=" + this.getColumnNameTrimPattern() + ", defaultJavaTypeModifierClass=" + this.getDefaultJavaTypeModifierClass() + ", targetLocation=" + this.getTargetLocation() + ", targetPackage=" + this.getTargetPackage() + ", targetConnection=" + this.getTargetConnection() + ", lombokConfigs=" + this.getLombokConfigs() + ", tableNames=" + this.getTableNames() + ")";
    }

    public GeneratorProperties() {
    }

    public GeneratorProperties(Set<GeneratorType> generatorTypes, boolean extendDynamicMapper, boolean overwrite, boolean generateReturnedKey, boolean generateComment, String tableNameTrimPattern, String columnNameTrimPattern, Class<? extends GeneratedJavaTypeModifier> defaultJavaTypeModifierClass, TargetLocation targetLocation, TargetPackage targetPackage, TargetConnection targetConnection, Set<LombokConfig> lombokConfigs, Set<String> tableNames) {
        this.generatorTypes = generatorTypes;
        this.extendDynamicMapper = extendDynamicMapper;
        this.overwrite = overwrite;
        this.generateReturnedKey = generateReturnedKey;
        this.generateComment = generateComment;
        this.tableNameTrimPattern = tableNameTrimPattern;
        this.columnNameTrimPattern = columnNameTrimPattern;
        this.defaultJavaTypeModifierClass = defaultJavaTypeModifierClass;
        this.targetLocation = targetLocation;
        this.targetPackage = targetPackage;
        this.targetConnection = targetConnection;
        this.lombokConfigs = lombokConfigs;
        this.tableNames = tableNames;
    }

    public static class TargetConnection {
        private String jdbcDriverClassName;
        private String jdbcConnectionUrl;
        private String username;
        private String password;

        public String getJdbcDriverClassName() {
            return this.jdbcDriverClassName;
        }

        public String getJdbcConnectionUrl() {
            return this.jdbcConnectionUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return "GeneratorProperties.TargetConnection(jdbcDriverClassName=" + this.getJdbcDriverClassName() + ", jdbcConnectionUrl=" + this.getJdbcConnectionUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }

        public TargetConnection() {
        }

        public TargetConnection(String jdbcDriverClassName, String jdbcConnectionUrl, String username, String password) {
            this.jdbcDriverClassName = jdbcDriverClassName;
            this.jdbcConnectionUrl = jdbcConnectionUrl;
            this.username = username;
            this.password = password;
        }
    }

    public static class TargetPackage {
        private String basePackage;
        private String modelPackage;
        private String mapperInterfacePackage;
        private String mapperXmlPackage;

        public String getFullModelPackage() {
            return Stream.of(this.basePackage, this.modelPackage).filter(StringUtils::isNotBlank).collect(Collectors.joining("."));
        }

        public String getFullMapperInterfacePackage() {
            return Stream.of(this.basePackage, this.mapperInterfacePackage).filter(StringUtils::isNotBlank).collect(Collectors.joining("."));
        }

        public String getBasePackage() {
            return this.basePackage;
        }

        public String getModelPackage() {
            return this.modelPackage;
        }

        public String getMapperInterfacePackage() {
            return this.mapperInterfacePackage;
        }

        public String getMapperXmlPackage() {
            return this.mapperXmlPackage;
        }

        public String toString() {
            return "GeneratorProperties.TargetPackage(basePackage=" + this.getBasePackage() + ", modelPackage=" + this.getModelPackage() + ", mapperInterfacePackage=" + this.getMapperInterfacePackage() + ", mapperXmlPackage=" + this.getMapperXmlPackage() + ")";
        }

        public TargetPackage() {
        }

        public TargetPackage(String basePackage, String modelPackage, String mapperInterfacePackage, String mapperXmlPackage) {
            this.basePackage = basePackage;
            this.modelPackage = modelPackage;
            this.mapperInterfacePackage = mapperInterfacePackage;
            this.mapperXmlPackage = mapperXmlPackage;
        }
    }

    public static class TargetLocation {
        private String baseLocation;
        private String javaLocation;
        private String mapperXmlLocation;

        public String getFullJavaLocation() {
            if (StringUtils.isNotBlank((CharSequence)this.baseLocation) && StringUtils.endsWith((CharSequence)this.baseLocation, (CharSequence)"/")) {
                this.baseLocation = StringUtils.substringBeforeLast((String)this.baseLocation, (String)"/");
            }
            return Stream.of(this.baseLocation, this.javaLocation).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
        }

        public String getFullMapperXmlLocation() {
            if (StringUtils.isNotBlank((CharSequence)this.baseLocation) && StringUtils.endsWith((CharSequence)this.baseLocation, (CharSequence)"/")) {
                this.baseLocation = StringUtils.substringBeforeLast((String)this.baseLocation, (String)"/");
            }
            return Stream.of(this.baseLocation, this.mapperXmlLocation).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
        }

        public String getBaseLocation() {
            return this.baseLocation;
        }

        public String getJavaLocation() {
            return this.javaLocation;
        }

        public String getMapperXmlLocation() {
            return this.mapperXmlLocation;
        }

        public String toString() {
            return "GeneratorProperties.TargetLocation(baseLocation=" + this.getBaseLocation() + ", javaLocation=" + this.getJavaLocation() + ", mapperXmlLocation=" + this.getMapperXmlLocation() + ")";
        }

        public TargetLocation() {
        }

        public TargetLocation(String baseLocation, String javaLocation, String mapperXmlLocation) {
            this.baseLocation = baseLocation;
            this.javaLocation = javaLocation;
            this.mapperXmlLocation = mapperXmlLocation;
        }
    }
}

