/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.core;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.internal.DefaultShellCallback;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.ContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.ContextGeneratorFactory;
import pro.chenggang.project.reactive.mybatis.support.generator.plugin.type.GeneratedJavaTypeModifier;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.FluentGeneratorPropertiesLoader;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorProperties;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesBuilder;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesHolder;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorPropertiesLoader;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.YamlGeneratorPropertiesLoader;

public class MybatisDynamicCodeGenerator {
    private final ContextGeneratorFactory contextGeneratorFactory = new ContextGeneratorFactory();

    private MybatisDynamicCodeGenerator() {
    }

    private MybatisDynamicCodeGenerator(GeneratorPropertiesLoader generatorPropertiesLoader) {
        GeneratorPropertiesHolder.getInstance().setGeneratorPropertiesLoader(generatorPropertiesLoader);
    }

    public static MybatisDynamicCodeGenerator withGeneratorPropertiesLoader(GeneratorPropertiesLoader generatorPropertiesLoader) {
        return new MybatisDynamicCodeGenerator(generatorPropertiesLoader);
    }

    public static MybatisDynamicCodeGenerator withYamlConfiguration() {
        return new MybatisDynamicCodeGenerator(new YamlGeneratorPropertiesLoader());
    }

    public static GeneratorPropertiesBuilder withGeneratorPropertiesBuilder() {
        FluentGeneratorPropertiesLoader fluentGeneratorPropertiesLoader = new FluentGeneratorPropertiesLoader(new Configurer(new MybatisDynamicCodeGenerator()));
        GeneratorPropertiesHolder.getInstance().setGeneratorPropertiesLoader(fluentGeneratorPropertiesLoader);
        return fluentGeneratorPropertiesLoader.getGeneratorPropertiesBuilder();
    }

    public static MybatisDynamicCodeGenerator withYamlConfiguration(String configurationFileName) {
        if (StringUtils.isBlank((CharSequence)configurationFileName)) {
            throw new IllegalArgumentException("The configuration file name can not be blank");
        }
        if (StringUtils.endsWithAny((CharSequence)configurationFileName, (CharSequence[])new CharSequence[]{"yaml", "yml"})) {
            throw new IllegalArgumentException("The configuration file type must be yaml or yml");
        }
        return new MybatisDynamicCodeGenerator(new YamlGeneratorPropertiesLoader(configurationFileName));
    }

    public void generate() {
        GeneratorProperties generatorProperties = GeneratorPropertiesHolder.getInstance().getGeneratorProperties();
        generatorProperties.validate();
        Configuration configuration = this.getConfiguration(generatorProperties);
        DefaultShellCallback callback = new DefaultShellCallback(generatorProperties.isOverwrite());
        ArrayList warnings = new ArrayList();
        try {
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(configuration, (ShellCallback)callback, warnings);
            myBatisGenerator.generate((ProgressCallback)new VerboseProgressCallback());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        warnings.forEach(System.out::println);
    }

    private Configuration getConfiguration(GeneratorProperties generatorProperties) {
        Configuration configuration = new Configuration();
        generatorProperties.getGeneratorTypes().stream().map(this.contextGeneratorFactory::getContextGenerator).filter(Optional::isPresent).map(Optional::get).map(contextGenerator -> contextGenerator.generateContext(generatorProperties)).forEach(arg_0 -> ((Configuration)configuration).addContext(arg_0));
        return configuration;
    }

    public Configurer customConfigure() {
        return new Configurer(this);
    }

    public static class Configurer {
        private final MybatisDynamicCodeGenerator mybatisDynamicCodeGenerator;

        public Configurer(MybatisDynamicCodeGenerator mybatisDynamicCodeGenerator) {
            this.mybatisDynamicCodeGenerator = mybatisDynamicCodeGenerator;
        }

        public GeneratorPropertiesBuilder customizeGeneratorProperties() {
            return new GeneratorPropertiesBuilder(GeneratorPropertiesHolder.getInstance().getGeneratorProperties(), this);
        }

        public Configurer configureGenerateBasePackage(String baseLocation, String basePackage) {
            return new GeneratorPropertiesBuilder(GeneratorPropertiesHolder.getInstance().getGeneratorProperties(), this).targetLocationBuilder().baseLocation(baseLocation).thenBuilder().targetPackageBuilder().basePackage(basePackage).thenPropertiesBuilder().thenConfigurer();
        }

        public Configurer configureDefaultJavaTypeModifier(Class<? extends GeneratedJavaTypeModifier> javaTypeModifierClass) {
            return new GeneratorPropertiesBuilder(GeneratorPropertiesHolder.getInstance().getGeneratorProperties(), this).defaultJavaTypeModifierClass(javaTypeModifierClass).thenConfigurer();
        }

        public Configurer applyGenerateBasePackageFromClass(Class<?> specificClass) {
            return new GeneratorPropertiesBuilder(GeneratorPropertiesHolder.getInstance().getGeneratorProperties(), this).targetPackageBuilder().basePackage(specificClass.getPackage().getName()).thenPropertiesBuilder().thenConfigurer();
        }

        public Configurer registerContextGenerator(ContextGenerator contextGenerator) {
            this.mybatisDynamicCodeGenerator.contextGeneratorFactory.registerContextGenerator(contextGenerator);
            return this;
        }

        public MybatisDynamicCodeGenerator toGenerator() {
            return this.mybatisDynamicCodeGenerator;
        }
    }
}

