/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.core;

import java.util.ArrayList;
import java.util.Objects;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.internal.DefaultShellCallback;
import pro.chenggang.project.reactive.mybatis.support.generator.core.GeneratorConfigurationFactory;
import pro.chenggang.project.reactive.mybatis.support.generator.core.PropertiesHolder;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.MyBatisSimpleContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.core.context.MybatisDynamicContextGenerator;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorExtensionProperties;

public class MybatisDynamicCodeGenerator {
    private final GeneratorConfigurationFactory configurationFactory = this.initConfigurationFactory();

    private MybatisDynamicCodeGenerator() {
    }

    private GeneratorConfigurationFactory initConfigurationFactory() {
        GeneratorConfigurationFactory configurationFactory = new GeneratorConfigurationFactory();
        configurationFactory.addContextGenerator(new MybatisDynamicContextGenerator());
        configurationFactory.addContextGenerator(new MyBatisSimpleContextGenerator());
        return configurationFactory;
    }

    public void generate() {
        this.initProperties(null, false);
        this.generateInternal();
    }

    public void generate(Class executeClass) {
        if (Objects.isNull(executeClass)) {
            throw new IllegalArgumentException("Execute Class Must Be Not Null");
        }
        this.initProperties(executeClass.getPackage().getName(), true);
        this.generateInternal();
    }

    public void generate(String basePackage) {
        this.initProperties(basePackage, true);
        this.generateInternal();
    }

    private void initProperties(String basePackage, boolean forceBasePackage) {
        GeneratorExtensionProperties properties = PropertiesHolder.getInstance().getProperties();
        if (forceBasePackage) {
            properties.setBasePackage(basePackage);
        }
        properties.validateByDefault();
    }

    private void generateInternal() {
        Configuration configuration = this.configurationFactory.getConfiguration();
        GeneratorExtensionProperties properties = PropertiesHolder.getInstance().getProperties();
        DefaultShellCallback callback = new DefaultShellCallback(properties.isOverwrite());
        ArrayList warnings = new ArrayList();
        try {
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(configuration, (ShellCallback)callback, warnings);
            myBatisGenerator.generate((ProgressCallback)new VerboseProgressCallback());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        warnings.forEach(System.out::println);
    }

    public static MybatisDynamicCodeGenerator getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final MybatisDynamicCodeGenerator INSTANCE = new MybatisDynamicCodeGenerator();

        private InstanceHolder() {
        }
    }
}

