/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.properties;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import pro.chenggang.project.reactive.mybatis.support.generator.annotation.Required;
import pro.chenggang.project.reactive.mybatis.support.generator.option.GeneratorType;
import pro.chenggang.project.reactive.mybatis.support.generator.option.LombokConfig;

public class GeneratorExtensionProperties {
    public static final String PROPERTIES_FILE_NAME_YAML = "mybatis-generator.yaml";
    public static final String PROPERTIES_FILE_NAME_YML = "mybatis-generator.yml";
    private String basePackage;
    private String parentLocation = "";
    @Required
    private String javaLocation = "src/main/java";
    @Required
    private String mapperXmlLocation = "src/main/resources";
    @Required
    private String modelPackage = "entity.model";
    @Required
    private String mapperInterfacePackage = "mapper";
    @Required
    private String mapperXmPackage = "mapper";
    @Required
    private String driverClass;
    @Required
    private String connectionUrl;
    @Required
    private String username;
    @Required
    private String password;
    private Set<String> tableName;
    private String tableTrimPattern;
    private LinkedHashSet<LombokConfig> lombok;
    private Set<GeneratorType> generateType;
    private boolean generateComment = true;
    private boolean extendDynamicMapper = false;
    private boolean overwrite = true;
    private boolean generateReturnedKey = true;

    public void validateByDefault() {
        Stream.of(this.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(Required.class) && String.class.isAssignableFrom(field.getType())).peek(field -> field.setAccessible(true)).forEach(field -> {
            Object fieldValue = null;
            try {
                fieldValue = field.get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (Objects.isNull(fieldValue)) {
                throw new IllegalArgumentException("Mybatis Generator Properties ( " + field.getName() + " ) Must Be Set");
            }
            String fieldStringValue = (String)fieldValue;
            if (StringUtils.isEmpty((CharSequence)fieldStringValue)) {
                throw new IllegalArgumentException("Mybatis Generator Properties ( " + field.getName() + " ) Must Be Set");
            }
        });
        if (StringUtils.isEmpty((CharSequence)this.basePackage)) {
            throw new IllegalArgumentException("Mybatis Generator Properties ( basePackage ) Must Be Set");
        }
        if (Objects.isNull(this.tableName) || this.tableName.isEmpty()) {
            this.tableName = new HashSet<String>();
            this.tableName.add("%");
        }
        if (Objects.isNull(this.lombok)) {
            this.lombok = new LinkedHashSet();
        }
        if (Objects.isNull(this.generateType) || this.generateType.isEmpty()) {
            this.generateType = new HashSet<GeneratorType>();
            this.generateType.add(GeneratorType.SIMPLE);
            this.generateType.add(GeneratorType.DYNAMIC);
        }
        if (!"".equals(this.parentLocation) && !this.parentLocation.endsWith("/")) {
            this.parentLocation = this.parentLocation + "/";
        }
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getParentLocation() {
        return this.parentLocation;
    }

    public String getJavaLocation() {
        return this.javaLocation;
    }

    public String getMapperXmlLocation() {
        return this.mapperXmlLocation;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public String getMapperInterfacePackage() {
        return this.mapperInterfacePackage;
    }

    public String getMapperXmPackage() {
        return this.mapperXmPackage;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getTableName() {
        return this.tableName;
    }

    public String getTableTrimPattern() {
        return this.tableTrimPattern;
    }

    public LinkedHashSet<LombokConfig> getLombok() {
        return this.lombok;
    }

    public Set<GeneratorType> getGenerateType() {
        return this.generateType;
    }

    public boolean isGenerateComment() {
        return this.generateComment;
    }

    public boolean isExtendDynamicMapper() {
        return this.extendDynamicMapper;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isGenerateReturnedKey() {
        return this.generateReturnedKey;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setParentLocation(String parentLocation) {
        this.parentLocation = parentLocation;
    }

    public void setJavaLocation(String javaLocation) {
        this.javaLocation = javaLocation;
    }

    public void setMapperXmlLocation(String mapperXmlLocation) {
        this.mapperXmlLocation = mapperXmlLocation;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setMapperInterfacePackage(String mapperInterfacePackage) {
        this.mapperInterfacePackage = mapperInterfacePackage;
    }

    public void setMapperXmPackage(String mapperXmPackage) {
        this.mapperXmPackage = mapperXmPackage;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableName(Set<String> tableName) {
        this.tableName = tableName;
    }

    public void setTableTrimPattern(String tableTrimPattern) {
        this.tableTrimPattern = tableTrimPattern;
    }

    public void setLombok(LinkedHashSet<LombokConfig> lombok) {
        this.lombok = lombok;
    }

    public void setGenerateType(Set<GeneratorType> generateType) {
        this.generateType = generateType;
    }

    public void setGenerateComment(boolean generateComment) {
        this.generateComment = generateComment;
    }

    public void setExtendDynamicMapper(boolean extendDynamicMapper) {
        this.extendDynamicMapper = extendDynamicMapper;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setGenerateReturnedKey(boolean generateReturnedKey) {
        this.generateReturnedKey = generateReturnedKey;
    }

    public String toString() {
        return "GeneratorExtensionProperties(basePackage=" + this.getBasePackage() + ", parentLocation=" + this.getParentLocation() + ", javaLocation=" + this.getJavaLocation() + ", mapperXmlLocation=" + this.getMapperXmlLocation() + ", modelPackage=" + this.getModelPackage() + ", mapperInterfacePackage=" + this.getMapperInterfacePackage() + ", mapperXmPackage=" + this.getMapperXmPackage() + ", driverClass=" + this.getDriverClass() + ", connectionUrl=" + this.getConnectionUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableName=" + this.getTableName() + ", tableTrimPattern=" + this.getTableTrimPattern() + ", lombok=" + this.getLombok() + ", generateType=" + this.getGenerateType() + ", generateComment=" + this.isGenerateComment() + ", extendDynamicMapper=" + this.isExtendDynamicMapper() + ", overwrite=" + this.isOverwrite() + ", generateReturnedKey=" + this.isGenerateReturnedKey() + ")";
    }
}

