/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.generator.core;

import java.io.InputStream;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;
import pro.chenggang.project.reactive.mybatis.support.generator.properties.GeneratorExtensionProperties;

public class PropertiesHolder {
    private GeneratorExtensionProperties generatorExtensionProperties;
    private Yaml yaml = new Yaml();

    public GeneratorExtensionProperties getProperties(boolean reload) {
        if (reload) {
            this.generatorExtensionProperties = this.readProperties();
        }
        return this.generatorExtensionProperties;
    }

    public GeneratorExtensionProperties getProperties() {
        if (Objects.isNull(this.generatorExtensionProperties)) {
            return this.getProperties(true);
        }
        return this.getProperties(false);
    }

    private GeneratorExtensionProperties readProperties() {
        InputStream propertiesInputStream = this.getClass().getClassLoader().getResourceAsStream("mybatis-generator.yml");
        if (Objects.isNull(propertiesInputStream)) {
            propertiesInputStream = this.getClass().getClassLoader().getResourceAsStream("mybatis-generator.yaml");
        }
        if (Objects.isNull(propertiesInputStream)) {
            throw new IllegalArgumentException("mybatis-generator.yaml or mybatis-generator.yml should be classpath");
        }
        GeneratorExtensionProperties properties = (GeneratorExtensionProperties)this.yaml.loadAs(propertiesInputStream, GeneratorExtensionProperties.class);
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("Can Not Reader mybatis-generator.yaml or mybatis-generator.yml, GeneratorExtensionProperties Is Null ");
        }
        return properties;
    }

    public static PropertiesHolder getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private PropertiesHolder() {
    }

    private static class InstanceHolder {
        private static final PropertiesHolder INSTANCE = new PropertiesHolder();

        private InstanceHolder() {
        }
    }
}

