/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.utils;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import pro.axenix_innovation.axenapi.model.ClassData;

public class JavaPoetHelper {
    private static final String CONSTRUCTOR_PARAMETER_ASSIGNMENT_STATEMENT = "this.$N = $N";

    public static FieldSpec constructField(ClassData type, String objectName, Modifier ... modifiers) {
        return FieldSpec.builder((TypeName)JavaPoetHelper.typeNameByClassData(type), (String)objectName, (Modifier[])modifiers).build();
    }

    public static FieldSpec constructField(ClassData type, String objectName, AnnotationSpec annotation, Modifier ... modifiers) {
        return FieldSpec.builder((TypeName)JavaPoetHelper.typeNameByClassData(type), (String)objectName, (Modifier[])modifiers).addAnnotation(annotation).build();
    }

    public static FieldSpec constructField(ClassData type, String objectName, List<AnnotationSpec> annotations, Modifier ... modifiers) {
        return FieldSpec.builder((TypeName)JavaPoetHelper.typeNameByClassData(type), (String)objectName, (Modifier[])modifiers).addAnnotations(annotations).build();
    }

    public static FieldSpec constructField(Class<?> type, String objectName, Modifier ... modifiers) {
        return FieldSpec.builder(type, (String)objectName, (Modifier[])modifiers).build();
    }

    public static FieldSpec constructField(Class<?> type, String objectName, AnnotationSpec annotation, Modifier ... modifiers) {
        return FieldSpec.builder(type, (String)objectName, (Modifier[])modifiers).addAnnotation(annotation).build();
    }

    public static FieldSpec constructField(Class<?> type, String objectName, List<AnnotationSpec> annotations, Modifier ... modifiers) {
        return FieldSpec.builder(type, (String)objectName, (Modifier[])modifiers).addAnnotations(annotations).build();
    }

    public static CodeBlock constructConstructorParameterAssignment(String objectName) {
        return CodeBlock.builder().addStatement(CONSTRUCTOR_PARAMETER_ASSIGNMENT_STATEMENT, new Object[]{objectName, objectName}).build();
    }

    public static JavaFile constructDefaultDtoJavaFile(String className, String packageName, List<FieldSpec> fields) {
        TypeSpec typeSpec = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(JavaPoetHelper.constructDefaultDtoAnnotations()).addFields(fields).build();
        return JavaFile.builder((String)packageName, (TypeSpec)typeSpec).indent("    ").build();
    }

    public static JavaFile constructDefaultDtoJavaFile(String className, String packageName, List<FieldSpec> fields, AnnotationSpec additionalAnnotation) {
        ArrayList<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>(JavaPoetHelper.constructDefaultDtoAnnotations());
        annotations.add(additionalAnnotation);
        TypeSpec typeSpec = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(annotations).addFields(fields).build();
        return JavaFile.builder((String)packageName, (TypeSpec)typeSpec).indent("    ").build();
    }

    public static CodeBlock constructFakeReturnStatement(ClassData type) {
        return CodeBlock.builder().addStatement("return new $T()", new Object[]{JavaPoetHelper.typeNameByClassData(type)}).build();
    }

    public static TypeName typeNameByClassData(ClassData type) {
        if (type.isArray()) {
            return ArrayTypeName.of((TypeName)ClassName.get((String)type.getPackageName(), (String)type.getSimpleClassName(), (String[])new String[0]));
        }
        return ClassName.get((String)type.getPackageName(), (String)type.getSimpleClassName(), (String[])new String[0]);
    }

    public static AnnotationSpec constructApiModelAnnotation(String description) {
        return AnnotationSpec.builder(Schema.class).addMember("description", "$S", new Object[]{description}).build();
    }

    public static AnnotationSpec constructApiModelPropertyAnnotation(String description, boolean required) {
        return AnnotationSpec.builder(Schema.class).addMember("value", "$S", new Object[]{description}).addMember("required", "$L", new Object[]{required}).build();
    }

    private static List<AnnotationSpec> constructDefaultDtoAnnotations() {
        return Arrays.asList(AnnotationSpec.builder(Data.class).build(), AnnotationSpec.builder(Builder.class).build(), AnnotationSpec.builder(NoArgsConstructor.class).build(), AnnotationSpec.builder(AllArgsConstructor.class).build());
    }

    private JavaPoetHelper() {
    }
}

