/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.springframework.messaging.handler.annotation.Payload;

public class ElementHelper {
    private final ProcessingEnvironment processingEnvironment;

    public ElementHelper(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public boolean existsDtoInParameters(ExecutableElement executableElement) {
        List<? extends VariableElement> variableElements = executableElement.getParameters();
        if (variableElements.isEmpty()) {
            return false;
        }
        if (variableElements.size() == 1) {
            return true;
        }
        return variableElements.stream().anyMatch(this::isPayload);
    }

    public boolean isPayload(VariableElement variableElement) {
        return Objects.nonNull(variableElement.getAnnotation(Payload.class));
    }

    public VariableElement getPayloadVariableElement(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() == 1) {
            return parameters.get(0);
        }
        return parameters.stream().filter(this::isPayload).findFirst().orElse(null);
    }

    public boolean isArrayTypeMirror(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    public boolean isStringOrEnumTypeMirror(TypeMirror typeMirror) {
        TypeElement typeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(typeMirror);
        return typeElement.getKind() == ElementKind.ENUM || typeElement.getSimpleName().toString().equals("String");
    }

    public String getClassNameByTypeMirror(TypeMirror typeMirror) {
        TypeMirror currentTypeMirror = typeMirror;
        if (this.isArrayTypeMirror(typeMirror)) {
            currentTypeMirror = ((ArrayType)typeMirror).getComponentType();
        }
        TypeElement typeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(currentTypeMirror);
        return typeElement.getSimpleName().toString();
    }

    public String getPackageNameByTypeMirror(TypeMirror typeMirror) {
        TypeMirror currentTypeMirror = typeMirror;
        if (this.isArrayTypeMirror(typeMirror)) {
            currentTypeMirror = ((ArrayType)typeMirror).getComponentType();
        }
        TypeElement typeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(currentTypeMirror);
        ArrayList<String> packageElements = new ArrayList<String>();
        Element element = typeElement.getEnclosingElement();
        while (element instanceof TypeElement) {
            packageElements.add(element.getSimpleName().toString());
            element = element.getEnclosingElement();
        }
        packageElements.add(((PackageElement)element).getQualifiedName().toString());
        Collections.reverse(packageElements);
        return String.join((CharSequence)".", packageElements);
    }

    public String getQualifiedClassNameByTypeMirror(TypeMirror typeMirror) {
        TypeMirror currentTypeMirror = typeMirror;
        if (this.isArrayTypeMirror(typeMirror)) {
            currentTypeMirror = ((ArrayType)typeMirror).getComponentType();
        }
        TypeElement typeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(currentTypeMirror);
        return typeElement.getQualifiedName().toString();
    }

    public TypeMirror getReturnedTypeMirror(ExecutableElement method) {
        TypeMirror returnedTypeMirror = method.getReturnType();
        if (returnedTypeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnedTypeMirror;
            List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
            if (arguments.size() != 1) {
                return null;
            }
            return arguments.get(0);
        }
        return null;
    }

    public AnnotationMirror getAnnotationMirrorByAnnotation(Element typeElement, Class<?> annotationClass) {
        List<? extends AnnotationMirror> annotationMirrors = typeElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String simpleName;
            String key = annotationMirror.getAnnotationType().toString();
            if (!Objects.equals(key, simpleName = annotationClass.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public TypeMirror getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        if (annotationMirror == null) {
            return null;
        }
        Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> entries = annotationMirror.getElementValues().entrySet();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : entries) {
            String annotationKey = entry.getKey().getSimpleName().toString();
            if (!Objects.equals(annotationKey, key)) continue;
            return (TypeMirror)entry.getValue().getValue();
        }
        return null;
    }

    public <T> T findAnnotationValue(Class<T> clazz, AnnotationMirror annotationMirror, String key) {
        Object value = annotationMirror.getElementValues().entrySet().stream().filter(entry -> Objects.equals(key, ((ExecutableElement)entry.getKey()).getSimpleName().toString())).map(entry -> ((AnnotationValue)entry.getValue()).getValue()).findFirst().orElse(null);
        if (Objects.isNull(value)) {
            return null;
        }
        return clazz.cast(value);
    }

    public <T> List<T> findListAnnotationValue(Class<T> clazz, AnnotationMirror annotationMirror, String key) {
        List values = annotationMirror.getElementValues().entrySet().stream().filter(entry -> Objects.equals(key, ((ExecutableElement)entry.getKey()).getSimpleName().toString())).map(entry -> (List)((AnnotationValue)entry.getValue()).getValue()).findFirst().orElse(null);
        if (Objects.isNull(values)) {
            return Collections.emptyList();
        }
        return values.stream().map(AnnotationValue::getValue).map(clazz::cast).collect(Collectors.toList());
    }

    public boolean enumElementExists(TypeMirror enumTypeMirror, String enumElement) {
        TypeElement typeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(enumTypeMirror);
        if (typeElement.getKind() != ElementKind.ENUM) {
            return true;
        }
        return typeElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.ENUM_CONSTANT).anyMatch(element -> element.getSimpleName().toString().equals(enumElement));
    }

    public boolean checkMirrorTypeContainsField(TypeMirror typeMirror, String requiredProperty) {
        TypeElement typeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(typeMirror);
        List fieldPathList = Arrays.stream(requiredProperty.split("\\.")).collect(Collectors.toList());
        String fieldPath = (String)fieldPathList.get(0);
        Optional<Element> nestedElement = typeElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.FIELD).filter(element -> element.getSimpleName().toString().equals(fieldPath)).findFirst();
        if (nestedElement.isEmpty()) {
            return false;
        }
        if (fieldPathList.size() == 1) {
            return true;
        }
        fieldPathList.remove(0);
        String nextAbsoluteFieldPath = String.join((CharSequence)".", fieldPathList);
        return this.checkMirrorTypeContainsField(nestedElement.get().asType(), nextAbsoluteFieldPath);
    }
}

