/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.tools.StandardLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxenAPIProperties {
    private static final Logger log = LoggerFactory.getLogger(AxenAPIProperties.class);
    public static final String ENG_LOCALE = "eng";
    public static final String RUS_LOCALE = "rus";
    private String packageName;
    private String annotationName;
    private String tokenHeader;
    private boolean useKafkaHandlerAnnotation = true;
    private String language;
    public static final String DEFAULT_HANDLER_VALUE = "org.springframework.kafka.annotation.KafkaHandler";
    public static final String PROPERTIES_FILE_NAME = "axenapi.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxenAPIProperties(Filer filer) {
        Properties props = new Properties();
        FileInputStream fileInputStream = null;
        try {
            String root = Path.of(filer.getResource(StandardLocation.CLASS_OUTPUT, "", "-").toUri()).getParent().getParent().getParent().getParent().getParent().toString();
            fileInputStream = new FileInputStream(root + "/axenapi.properties");
            props.load(fileInputStream);
            this.packageName = props.getProperty("package");
            this.annotationName = props.getProperty("kafka.handler.annotaion");
            String kafkaHandlerString = props.getProperty("use.standart.kafkahandler.annotation");
            String tokenHeader = props.getProperty("kafka.access.token.header");
            this.tokenHeader = tokenHeader == null ? "Authorization" : tokenHeader;
            this.language = props.getProperty("language");
            boolean bl = this.useKafkaHandlerAnnotation = kafkaHandlerString == null || Boolean.parseBoolean(kafkaHandlerString);
            if (this.annotationName == null || this.annotationName.isEmpty()) {
                this.annotationName = DEFAULT_HANDLER_VALUE;
            }
            if (this.language == null || this.language.isBlank() || !ENG_LOCALE.equals(this.language) && !RUS_LOCALE.equals(this.language)) {
                this.language = ENG_LOCALE;
            }
        }
        catch (IOException ioException) {
            System.out.println("Failed to read file or property");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public boolean isUseKafkaHandlerAnnotation() {
        return this.useKafkaHandlerAnnotation;
    }

    public String getLanguage() {
        return this.language;
    }
}

