/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import pro.axenix_innovation.axenapi.service.HeaderAccessorService;
import pro.axenix_innovation.axenapi.service.KafkaClient4AxenAPI;
import pro.axenix_innovation.axenapi.service.KafkaSenderService;
import pro.axenix_innovation.axenapi.service.ResponseHeaderExtractorService;
import pro.axenix_innovation.axenapi.utils.KafkaHeaderAccessor;

public class KafkaSenderServiceImpl
implements KafkaSenderService {
    @Value(value="${axenapi.headers.sendBytes:false}")
    private Boolean sendBytes;
    private final HeaderAccessorService headerAccessorService;
    private final KafkaClient4AxenAPI kafkaClient4AxenAPI;
    private final ResponseHeaderExtractorService responseHeaderExtractorService;

    @Override
    public void send(String topicName, Object message, Map<String, String> params, HttpServletResponse servletResponse) {
        KafkaHeaderAccessor headerAccessor = new KafkaHeaderAccessor();
        if (params != null && params.size() > 0) {
            MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message);
            for (Map.Entry<String, String> entry2 : params.entrySet()) {
                if (this.sendBytes.booleanValue()) {
                    messageBuilder.setHeader(entry2.getKey(), (Object)entry2.getValue().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                messageBuilder.setHeader(entry2.getKey(), (Object)entry2.getValue());
            }
            Message msg = messageBuilder.build();
            ProducerRecord producerRecord = new MessagingMessageConverter().fromMessage(msg, topicName);
            this.kafkaClient4AxenAPI.sendProducerRecord((ProducerRecord<String, Object>)producerRecord);
        } else {
            this.kafkaClient4AxenAPI.send(message, topicName, headerAccessor);
        }
        this.responseHeaderExtractorService.extractHeaders(headerAccessor).entrySet().forEach(entry -> servletResponse.setHeader((String)entry.getKey(), (String)entry.getValue()));
    }

    @Override
    public void send(String topicName, Object message, Map<String, String> params) {
        KafkaHeaderAccessor headerAccessor = new KafkaHeaderAccessor();
        if (params != null && params.size() > 0) {
            MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (this.sendBytes.booleanValue()) {
                    messageBuilder.setHeader(entry.getKey(), (Object)entry.getValue().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                messageBuilder.setHeader(entry.getKey(), (Object)entry.getValue());
            }
            Message msg = messageBuilder.build();
            ProducerRecord producerRecord = new MessagingMessageConverter().fromMessage(msg, topicName);
            this.kafkaClient4AxenAPI.sendProducerRecord((ProducerRecord<String, Object>)producerRecord);
        } else {
            this.kafkaClient4AxenAPI.send(message, topicName, headerAccessor);
        }
    }

    public KafkaSenderServiceImpl(HeaderAccessorService headerAccessorService, KafkaClient4AxenAPI kafkaClient4AxenAPI, ResponseHeaderExtractorService responseHeaderExtractorService) {
        this.headerAccessorService = headerAccessorService;
        this.kafkaClient4AxenAPI = kafkaClient4AxenAPI;
        this.responseHeaderExtractorService = responseHeaderExtractorService;
    }
}

