/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import pro.axenix_innovation.axenapi.code.generator.JmsControllerCodeGenerator;
import pro.axenix_innovation.axenapi.jms.JmsHandler;
import pro.axenix_innovation.axenapi.jms.JmsProperty;
import pro.axenix_innovation.axenapi.model.ClassData;
import pro.axenix_innovation.axenapi.model.jms.JmsHandlerMetadata;
import pro.axenix_innovation.axenapi.model.jms.PropertyMetadata;
import pro.axenix_innovation.axenapi.utils.AxenAPIProperties;
import pro.axenix_innovation.axenapi.utils.ElementHelper;

@SupportedAnnotationTypes(value={"org.axenix.swagger4kafka.annotation.jms.JmsHandler"})
public class JmsControllerProcessor
extends AbstractProcessor {
    private Messager messager;
    private ElementHelper helper;
    private JmsControllerCodeGenerator codeGenerator;
    private AxenAPIProperties properties;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.messager = processingEnvironment.getMessager();
        this.helper = new ElementHelper(processingEnvironment);
        this.codeGenerator = new JmsControllerCodeGenerator(processingEnvironment.getFiler());
        this.properties = new AxenAPIProperties(processingEnvironment.getFiler());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            TypeElement jmsHandlerAnnotationElement = annotations.stream().findFirst().orElse(null);
            if (jmsHandlerAnnotationElement == null) {
                return false;
            }
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(jmsHandlerAnnotationElement);
            ArrayList<JmsHandlerMetadata> handlers = new ArrayList<JmsHandlerMetadata>();
            for (Element element : annotatedElements) {
                if (!Objects.equals((Object)element.getKind(), (Object)ElementKind.CLASS)) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Annotation JmsHandler does support only classes", element);
                    continue;
                }
                String packageName = this.properties.getPackageName();
                if (packageName != null && !packageName.isBlank() && !element.asType().toString().startsWith(packageName)) continue;
                JmsHandler annotation = element.getAnnotation(JmsHandler.class);
                TypeMirror payloadTypeMirror = this.helper.getAnnotationValue(this.helper.getAnnotationMirrorByAnnotation(element, JmsHandler.class), "payload");
                handlers.add(JmsHandlerMetadata.builder().payload(this.classDataByTypeMirror(payloadTypeMirror)).destination(annotation.destination()).description(annotation.description()).jmsTemplateName(annotation.jmsTemplateName()).properties(this.propertiesMetadataByAnnotations(annotation.properties())).build());
            }
            this.codeGenerator.writeFile(handlers);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    private ClassData classDataByTypeMirror(TypeMirror typeMirror) {
        return ClassData.builder().simpleClassName(this.helper.getClassNameByTypeMirror(typeMirror)).packageName(this.helper.getPackageNameByTypeMirror(typeMirror)).qualifiedClassName(this.helper.getQualifiedClassNameByTypeMirror(typeMirror)).build();
    }

    private List<PropertyMetadata> propertiesMetadataByAnnotations(JmsProperty[] properties) {
        return Arrays.stream(properties).map(property -> new PropertyMetadata(property.name(), property.required())).collect(Collectors.toList());
    }
}

