/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.configuration;

import java.util.HashMap;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;
import pro.axenix_innovation.axenapi.configuration.AxenApiKafkaBootstrapConfig;
import pro.axenix_innovation.axenapi.service.KafkaBootstrapForAxenAPI;

@Configuration
@ConditionalOnProperty(prefix="axenapi.kafka.swagger", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={AxenApiKafkaBootstrapConfig.class})
public class KafkaProducerConfig {
    private final KafkaBootstrapForAxenAPI bootstrapAddress;

    public KafkaProducerConfig(KafkaBootstrapForAxenAPI bootstrapAddress) {
        this.bootstrapAddress = bootstrapAddress;
    }

    @Bean
    @ConditionalOnMissingBean
    public ProducerFactory<String, Object> producerFactory() {
        HashMap<String, Object> configProps = new HashMap<String, Object>();
        configProps.put("bootstrap.servers", this.bootstrapAddress.getBootstrapAddress());
        configProps.put("key.serializer", StringSerializer.class);
        configProps.put("value.serializer", JsonSerializer.class);
        return new DefaultKafkaProducerFactory(configProps);
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaTemplate<String, Object> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }
}

