/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import pro.axenix_innovation.axenapi.consts.Headers;
import pro.axenix_innovation.axenapi.jms.JmsTemplateRegistry;
import pro.axenix_innovation.axenapi.service.HeaderAccessorService;
import pro.axenix_innovation.axenapi.service.JmsSenderService;
import pro.axenix_innovation.axenapi.service.KafkaClient4AxenAPI;
import pro.axenix_innovation.axenapi.service.KafkaSenderService;
import pro.axenix_innovation.axenapi.service.RemoteMethodService;
import pro.axenix_innovation.axenapi.service.ResponseHeaderExtractorService;
import pro.axenix_innovation.axenapi.service.TokenProducerService;
import pro.axenix_innovation.axenapi.service.impl.DefaultJmsSenderService;
import pro.axenix_innovation.axenapi.service.impl.HeaderAccessorServiceImpl;
import pro.axenix_innovation.axenapi.service.impl.HeaderType;
import pro.axenix_innovation.axenapi.service.impl.KafkaSenderServiceImpl;
import pro.axenix_innovation.axenapi.service.impl.RemoteMethodServiceImpl;
import pro.axenix_innovation.axenapi.service.impl.ResponseHeaderExtractorServiceImpl;
import pro.axenix_innovation.axenapi.service.impl.TokenProducerServiceImpl;

@Configuration
@ConditionalOnProperty(prefix="axenapi.kafka.swagger", name={"enabled"}, havingValue="true")
@ComponentScan(basePackages={"pro.axenix_innovation.axenapi"})
public class AxenaAPIConfiguration {
    @Bean
    public HeaderAccessorService headerAccessorService(TokenProducerService tokenProducerService) {
        return new HeaderAccessorServiceImpl(tokenProducerService);
    }

    @Bean
    public JmsTemplateRegistry jmsTemplateRegistry() {
        return new JmsTemplateRegistry();
    }

    @Bean
    public JmsSenderService jmsSenderService(JmsTemplateRegistry jmsTemplateRegistry) {
        return new DefaultJmsSenderService(jmsTemplateRegistry);
    }

    @Bean
    KafkaSenderService kafkaSenderService(HeaderAccessorService headerAccessorService, KafkaClient4AxenAPI kafkaClient4AxenAPI, ResponseHeaderExtractorService responseHeaderExtractorService) {
        return new KafkaSenderServiceImpl(headerAccessorService, kafkaClient4AxenAPI, responseHeaderExtractorService);
    }

    @Bean
    public ResponseHeaderExtractorService responseHeaderExtractorService() {
        ResponseHeaderExtractorServiceImpl service = new ResponseHeaderExtractorServiceImpl();
        service.appendHeader(Headers.MESSAGE_ID.name(), HeaderType.UUID_TYPE);
        service.appendHeader(Headers.MESSAGE_GROUP_ID.name(), HeaderType.UUID_TYPE);
        service.appendHeader(Headers.TRACE_ID.name(), HeaderType.STRING_TYPE);
        service.appendHeader(Headers.CORRELATION_ID.name(), HeaderType.UUID_TYPE);
        return service;
    }

    @Bean
    public RemoteMethodService modelGeneratorService(ObjectMapper objectMapper) {
        return new RemoteMethodServiceImpl(objectMapper);
    }

    @Bean
    public TokenProducerService tokenProducerService() {
        return new TokenProducerServiceImpl();
    }
}

