/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.code.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.servlet.http.HttpServletResponse;
import javax.tools.JavaFileObject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.axenix_innovation.axenapi.configuration.AxenaAPIConfiguration;
import pro.axenix_innovation.axenapi.model.ClassData;
import pro.axenix_innovation.axenapi.model.JavaFileMetadata;
import pro.axenix_innovation.axenapi.model.ParamsData;
import pro.axenix_innovation.axenapi.model.ReturnedData;
import pro.axenix_innovation.axenapi.model.kafka.EndpointAnnotationsMetadata;
import pro.axenix_innovation.axenapi.model.kafka.KafkaHandlerData;
import pro.axenix_innovation.axenapi.model.kafka.KafkaListenerData;
import pro.axenix_innovation.axenapi.model.kafka.remote.RemoteMethodMetadata;
import pro.axenix_innovation.axenapi.service.KafkaSenderService;
import pro.axenix_innovation.axenapi.service.RemoteMethodService;
import pro.axenix_innovation.axenapi.utils.AxenAPIProperties;
import pro.axenix_innovation.axenapi.utils.JavaPoetHelper;

public class KafkaControllerCodeGenerator {
    private final Filer filer;
    private final AxenAPIProperties properties;

    public void writeFile(List<KafkaListenerData> listeners) throws Exception {
        List javaFiles = listeners.stream().map(KafkaListenerData::getHandlers).flatMap(Collection::stream).filter(handlerData -> Objects.nonNull(handlerData.getHandlerRemoteMethod())).map(this::constructRemoteMethodListModels).flatMap(Collection::stream).collect(Collectors.toList());
        listeners.stream().map(this::constructListenerController).forEach(javaFiles::add);
        for (JavaFileMetadata javaFileMetadata : javaFiles) {
            JavaFileObject builderFile = this.filer.createSourceFile(this.qualifiedClassName(javaFileMetadata), new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                javaFileMetadata.getJavaFile().writeTo((Appendable)out);
            }
        }
    }

    private JavaFileMetadata constructListenerController(KafkaListenerData listenerData) {
        String groupId = "";
        if (listenerData.getGroupId() != null && !listenerData.getGroupId().isBlank()) {
            groupId = listenerData.getGroupId();
        }
        List<FieldSpec> fields = Arrays.asList(JavaPoetHelper.constructField(KafkaSenderService.class, "kafkaSenderService", Modifier.PRIVATE, Modifier.FINAL), JavaPoetHelper.constructField(RemoteMethodService.class, "modelGeneratorServiceObject", Modifier.PRIVATE, Modifier.FINAL), JavaPoetHelper.constructField(String.class, "topicName", AnnotationSpec.builder(Value.class).addMember("value", "$S", new Object[]{listenerData.getTopics().get(0)}).build(), Modifier.PRIVATE), JavaPoetHelper.constructField(String.class, "groupId", AnnotationSpec.builder(Value.class).addMember("value", "$S", new Object[]{groupId}).build(), Modifier.PRIVATE));
        MethodSpec constructorMethodSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(KafkaSenderService.class, "kafkaSenderService", new Modifier[0]).addParameter(RemoteMethodService.class, "modelGeneratorServiceObject", new Modifier[0]).addCode(JavaPoetHelper.constructConstructorParameterAssignment("kafkaSenderService")).addCode(JavaPoetHelper.constructConstructorParameterAssignment("modelGeneratorServiceObject")).build();
        AnnotationSpec restControllerSpec = AnnotationSpec.builder(RestController.class).build();
        Object groupPrefix = "";
        if (!groupId.isBlank()) {
            groupPrefix = groupId + "/";
        }
        AnnotationSpec requestAnnotationSpec = AnnotationSpec.builder(RequestMapping.class).addMember("path", "$S", new Object[]{"/kafka/" + (String)groupPrefix + listenerData.getTopics().get(0)}).build();
        AnnotationSpec conditionalOnPropertySpec = AnnotationSpec.builder(ConditionalOnBean.class).addMember("value", "$T.class", new Object[]{AxenaAPIConfiguration.class}).build();
        TypeSpec controllerTypeSpec = TypeSpec.classBuilder((String)(listenerData.getListenerClassName() + "Controller")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addFields(fields).addMethod(constructorMethodSpec).addMethods(this.constructControllerEndpoints(listenerData.getHandlers())).addAnnotation(restControllerSpec).addAnnotation(requestAnnotationSpec).build();
        JavaFile javaFile = JavaFile.builder((String)"pro.axenix_innovation.axenapi.controller", (TypeSpec)controllerTypeSpec).indent("    ").build();
        return JavaFileMetadata.builder().className(listenerData.getListenerClassName() + "Controller").packageName("pro.axenix_innovation.axenapi.controller").javaFile(javaFile).build();
    }

    private List<MethodSpec> constructControllerEndpoints(List<KafkaHandlerData> handlers) {
        return handlers.stream().map(this::constructControllerEndpointsByHandler).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MethodSpec> constructControllerEndpointsByHandler(KafkaHandlerData handler) {
        MethodSpec mainMethod = this.constructMainHandlerMethod(handler);
        if (Objects.isNull(handler.getHandlerRemoteMethod())) {
            return Collections.singletonList(mainMethod);
        }
        ArrayList<MethodSpec> methodSpecList = new ArrayList<MethodSpec>();
        methodSpecList.add(mainMethod);
        methodSpecList.addAll(this.constructRemoteMethods(handler));
        return methodSpecList;
    }

    private MethodSpec constructMainHandlerMethod(KafkaHandlerData handler) {
        String functionName = "execute" + handler.getVariableData().getVariableType().getSimpleClassName();
        String path = "/" + handler.getVariableData().getVariableType().getSimpleClassName();
        List<AnnotationSpec> methodAnnotations = this.constructEndpointAnnotations(EndpointAnnotationsMetadata.builder().description(handler.getDescription()).params(handler.getParams()).returnedData(handler.getReturnedData()).tags(handler.getTags()).secured(handler.isSecured()).securityScheme(handler.getSecurityScheme()).build(), path);
        ParameterSpec payloadParameter = ParameterSpec.builder((TypeName)ClassName.get((String)handler.getVariableData().getVariableType().getPackageName(), (String)handler.getVariableData().getVariableType().getSimpleClassName(), (String[])new String[0]), (String)handler.getVariableData().getVariableName(), (Modifier[])new Modifier[0]).addAnnotation(RequestBody.class).build();
        AnnotationSpec.Builder hiddenBuilder = AnnotationSpec.builder(Parameter.class).addMember("hidden", "$L", new Object[]{true});
        ParameterSpec paramsParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), (String)"params", (Modifier[])new Modifier[0]).addAnnotation(RequestParam.class).addAnnotation(hiddenBuilder.build()).build();
        ParameterSpec responseParameter = ParameterSpec.builder(HttpServletResponse.class, (String)"servletResponse", (Modifier[])new Modifier[0]).build();
        ParameterSpec headers = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), (String)"headers", (Modifier[])new Modifier[0]).addAnnotation(RequestHeader.class).build();
        Object sendToBlock = "$N.send($N, $N, $N, $N)";
        if (handler.isSecured()) {
            String tokenToParams = "String authToken = headers.get(\"" + this.properties.getTokenHeader().toLowerCase() + "\"); \nif(authToken != null) params.put(\"" + this.properties.getTokenHeader() + "\", authToken);\n";
            sendToBlock = tokenToParams + (String)sendToBlock;
        }
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.addStatement((String)sendToBlock, new Object[]{"kafkaSenderService", "topicName", handler.getVariableData().getVariableName(), "params", "servletResponse"});
        if (Objects.nonNull(handler.getReturnedData())) {
            codeBlockBuilder.add(JavaPoetHelper.constructFakeReturnStatement(handler.getReturnedData().getReturnedType()));
        }
        CodeBlock codeBlock = codeBlockBuilder.build();
        TypeName returnedType = Objects.isNull(handler.getReturnedData()) ? TypeName.VOID : JavaPoetHelper.typeNameByClassData(handler.getReturnedData().getReturnedType());
        return MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(methodAnnotations).addParameter(payloadParameter).addParameter(paramsParameter).addParameter(responseParameter).addParameter(headers).addCode(codeBlock).returns(returnedType).build();
    }

    private List<MethodSpec> constructRemoteMethods(KafkaHandlerData handler) {
        return handler.getHandlerRemoteMethod().getMethods().stream().map(method -> this.constructRemoteMethod(handler, (RemoteMethodMetadata)method)).collect(Collectors.toList());
    }

    private MethodSpec constructRemoteMethod(KafkaHandlerData handler, RemoteMethodMetadata method) {
        String methodPropertyValue = this.snakeToCamelCase(method.getPropertyValue());
        String className = this.generateSupportDtoClassName(handler.getVariableData().getVariableType().getSimpleClassName(), methodPropertyValue);
        String functionName = "execute" + className;
        String path = "/" + className;
        List<AnnotationSpec> methodAnnotations = this.constructEndpointAnnotations(EndpointAnnotationsMetadata.builder().description(method.getDescription()).params(handler.getParams()).returnedData(handler.getReturnedData()).tags(method.getTags()).build(), path);
        ParameterSpec payloadParameter = ParameterSpec.builder((TypeName)ClassName.get((String)"pro.axenix_innovation.axenapi.dto", (String)this.generateSupportDtoClassName(handler.getVariableData().getVariableType().getSimpleClassName(), methodPropertyValue), (String[])new String[0]), (String)"generatedDto", (Modifier[])new Modifier[0]).addAnnotation(RequestBody.class).build();
        AnnotationSpec.Builder hiddenBuilder = AnnotationSpec.builder(Parameter.class).addMember("hidden", "$L", new Object[]{true});
        ParameterSpec paramsParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), (String)"params", (Modifier[])new Modifier[0]).addAnnotation(RequestParam.class).addAnnotation(hiddenBuilder.build()).build();
        ParameterSpec responseParameter = ParameterSpec.builder(HttpServletResponse.class, (String)"servletResponse", (Modifier[])new Modifier[0]).build();
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.add(this.constructLocalVariable(handler.getVariableData().getVariableType(), "originalDto", "generatedDto", "getOriginalDto"));
        ClassData variableType = Objects.isNull(method.getVariablesType()) ? ClassData.builder().simpleClassName(this.generateVariableDtoClassName(methodPropertyValue)).packageName("pro.axenix_innovation.axenapi.dto").build() : method.getVariablesType();
        codeBlockBuilder.add(this.constructLocalVariable(variableType, "data", "generatedDto", "getData"));
        codeBlockBuilder.add(this.constructMethodPropertyVariable(method.getPropertyValue(), handler.getHandlerRemoteMethod().getMethodPropertyType()));
        String injectPropertyBlock = "$N.replaceMethodAndVariables($N, $S, $N, $S, $N)";
        codeBlockBuilder.addStatement("$N.replaceMethodAndVariables($N, $S, $N, $S, $N)", new Object[]{"modelGeneratorServiceObject", "originalDto", handler.getHandlerRemoteMethod().getMethodPropertyName(), "methodPropertyValue", handler.getHandlerRemoteMethod().getVariablesPropertyName(), "data"});
        String sendToBlock = "$N.send($N, $N.getOriginalDto(), $N, $N)";
        codeBlockBuilder.addStatement("$N.send($N, $N.getOriginalDto(), $N, $N)", new Object[]{"kafkaSenderService", "topicName", "generatedDto", "params", "servletResponse"});
        if (Objects.nonNull(handler.getReturnedData())) {
            codeBlockBuilder.add(JavaPoetHelper.constructFakeReturnStatement(handler.getReturnedData().getReturnedType()));
        }
        CodeBlock codeBlock = codeBlockBuilder.build();
        TypeName returnedType = Objects.isNull(handler.getReturnedData()) ? TypeName.VOID : JavaPoetHelper.typeNameByClassData(handler.getReturnedData().getReturnedType());
        return MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(methodAnnotations).addParameter(payloadParameter).addParameter(paramsParameter).addParameter(responseParameter).addCode(codeBlock).returns(returnedType).addException(Exception.class).build();
    }

    private List<JavaFileMetadata> constructRemoteMethodListModels(KafkaHandlerData handlerData) {
        return handlerData.getHandlerRemoteMethod().getMethods().stream().map(method -> this.constructRemoteMethodModels(handlerData, (RemoteMethodMetadata)method)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<JavaFileMetadata> constructRemoteMethodModels(KafkaHandlerData kafkaHandlerData, RemoteMethodMetadata method) {
        ClassData variableType;
        JavaFileMetadata variableDto = null;
        if (Objects.isNull(method.getVariablesType())) {
            variableDto = this.constructRemoteMethodVariableDto(method);
            variableType = ClassData.builder().simpleClassName(variableDto.getClassName()).packageName(variableDto.getPackageName()).build();
        } else {
            variableType = method.getVariablesType();
        }
        JavaFileMetadata remoteMethodSupportDto = this.constructRemoteMethodSupportDto(kafkaHandlerData, method, variableType);
        if (Objects.isNull(variableDto)) {
            return Collections.singletonList(remoteMethodSupportDto);
        }
        return Arrays.asList(variableDto, remoteMethodSupportDto);
    }

    private JavaFileMetadata constructRemoteMethodVariableDto(RemoteMethodMetadata method) {
        String className = this.generateVariableDtoClassName(this.snakeToCamelCase(method.getPropertyValue()));
        List<FieldSpec> fields = method.getVariables().stream().map(variable -> JavaPoetHelper.constructField(variable.getType(), variable.getPropertyFieldName(), JavaPoetHelper.constructApiModelPropertyAnnotation(variable.getDescription(), false), Modifier.PRIVATE)).collect(Collectors.toList());
        JavaFile javaFile = JavaPoetHelper.constructDefaultDtoJavaFile(className, "pro.axenix_innovation.axenapi.dto", fields, JavaPoetHelper.constructApiModelAnnotation(String.format("rus".equals(this.properties.getLanguage()) ? "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043c\u0435\u0442\u043e\u0434\u0430 %s" : "Method parameters %s", method.getPropertyValue())));
        return JavaFileMetadata.builder().className(className).packageName("pro.axenix_innovation.axenapi.dto").javaFile(javaFile).build();
    }

    private JavaFileMetadata constructRemoteMethodSupportDto(KafkaHandlerData kafkaHandlerData, RemoteMethodMetadata method, ClassData variable) {
        String simpleClassName = kafkaHandlerData.getVariableData().getVariableType().getSimpleClassName();
        String className = this.generateSupportDtoClassName(simpleClassName, this.snakeToCamelCase(method.getPropertyValue()));
        List<FieldSpec> fields = Arrays.asList(JavaPoetHelper.constructField(kafkaHandlerData.getVariableData().getVariableType(), "originalDto", Arrays.asList(AnnotationSpec.builder(Valid.class).build(), AnnotationSpec.builder(NotNull.class).build(), JavaPoetHelper.constructApiModelPropertyAnnotation("rus".equals(this.properties.getLanguage()) ? "\u0418\u0441\u0445\u043e\u0434\u043d\u043e\u0435 \u0434\u0442\u043e" : "Original DTO", true)), Modifier.PRIVATE), JavaPoetHelper.constructField(variable, "data", Arrays.asList(AnnotationSpec.builder(Valid.class).build(), AnnotationSpec.builder(NotNull.class).build(), JavaPoetHelper.constructApiModelPropertyAnnotation(String.format("rus".equals(this.properties.getLanguage()) ? "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043c\u0435\u0442\u043e\u0434\u0430 %s" : "Method parameters %s", method.getPropertyValue()), true)), Modifier.PRIVATE));
        JavaFile javaFile = JavaPoetHelper.constructDefaultDtoJavaFile(className, "pro.axenix_innovation.axenapi.dto", fields, JavaPoetHelper.constructApiModelAnnotation(String.format("\u041e\u0431\u0435\u0440\u0442\u043a\u0430 \u0434\u043b\u044f \u043c\u0435\u0442\u043e\u0434\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c %s", simpleClassName)));
        return JavaFileMetadata.builder().className(className).packageName("pro.axenix_innovation.axenapi.dto").javaFile(javaFile).build();
    }

    public CodeBlock constructMethodPropertyVariable(String name, ClassData type) {
        ClassName className = ClassName.get((String)type.getPackageName(), (String)type.getSimpleClassName(), (String[])new String[0]);
        if (type.getSimpleClassName().equals("String")) {
            return CodeBlock.builder().addStatement("$T $N = $S", new Object[]{className, "methodPropertyValue", name}).build();
        }
        return CodeBlock.builder().addStatement("$T $N = $T.$N", new Object[]{className, "methodPropertyValue", className, name}).build();
    }

    public CodeBlock constructLocalVariable(ClassData type, String localVariableName, String innerDtoName, String innerDtoGetMethodName) {
        String getVariableBlock = "$T $N = $N.$N()";
        ClassName className = ClassName.get((String)type.getPackageName(), (String)type.getSimpleClassName(), (String[])new String[0]);
        return CodeBlock.builder().addStatement("$T $N = $N.$N()", new Object[]{className, localVariableName, innerDtoName, innerDtoGetMethodName}).build();
    }

    private List<AnnotationSpec> constructEndpointAnnotations(EndpointAnnotationsMetadata endpointMetadata, String path) {
        ArrayList<AnnotationSpec> methodAnnotations = new ArrayList<AnnotationSpec>();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(PostMapping.class).addMember("path", "$S", new Object[]{path}).build();
        methodAnnotations.add(annotationSpec);
        AnnotationSpec.Builder operationAnnotationBuilder = AnnotationSpec.builder(Operation.class).addMember("description", "$S", new Object[]{endpointMetadata.getDescription()});
        if (!endpointMetadata.getTags().isEmpty()) {
            CodeBlock codeBlock = (CodeBlock)endpointMetadata.getTags().stream().map(tag -> CodeBlock.of((String)"$S", (Object[])new Object[]{tag})).collect(CodeBlock.joining((String)",", (String)"{", (String)"}"));
            operationAnnotationBuilder.addMember("tags", codeBlock);
        }
        if (!endpointMetadata.getParams().isEmpty()) {
            List<AnnotationSpec> apiImplicitParam = this.constructAnnotationsByParams(endpointMetadata.getParams());
            apiImplicitParam.forEach(propertyAnnotation -> operationAnnotationBuilder.addMember("parameters", "$L", new Object[]{propertyAnnotation}));
        }
        methodAnnotations.add(operationAnnotationBuilder.build());
        methodAnnotations.add(this.constructResponseAnnotation(endpointMetadata.getReturnedData()));
        if (endpointMetadata.isSecured()) {
            AnnotationSpec.Builder openApiSecurityBuilder = AnnotationSpec.builder(SecurityRequirement.class).addMember("name", "$S", new Object[]{endpointMetadata.getSecurityScheme()});
            methodAnnotations.add(openApiSecurityBuilder.build());
        }
        return methodAnnotations;
    }

    private List<AnnotationSpec> constructAnnotationsByParams(List<ParamsData> params) {
        return params.stream().map(param -> AnnotationSpec.builder(Parameter.class).addMember("name", "$S", new Object[]{param.getName()}).addMember("in", "$L", new Object[]{"io.swagger.v3.oas.annotations.enums.ParameterIn.QUERY"}).addMember("schema", "$L", new Object[]{AnnotationSpec.builder(Schema.class).addMember("implementation", "$L", new Object[]{"String.class"}).build()}).addMember("required", "$L", new Object[]{param.getRequired()}).build()).collect(Collectors.toList());
    }

    private AnnotationSpec constructResponseAnnotation(ReturnedData returnedData) {
        AnnotationSpec.Builder responseAnnotationSpec = AnnotationSpec.builder(ApiResponse.class);
        responseAnnotationSpec.addMember("responseCode", "$S", new Object[]{"200"});
        String message = returnedData == null ? ("rus".equals(this.properties.getLanguage()) ? "\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442" : "No return value") : (returnedData.getReturnedTopicName().isEmpty() ? ("rus".equals(this.properties.getLanguage()) ? String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442 \u043e\u0442\u0432\u0435\u0442 %s \u0432 \u0442\u043e\u043f\u0438\u043a, \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0447\u0435\u0440\u0435\u0437 \u0445\u0435\u0434\u0435\u0440 replyTopic. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0435\u0440\u0435\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f", returnedData.getReturnedType().getSimpleClassName()) : String.format("Returns the reply %s to the topic passed through the replyTopic header. The return value is not intercepted", returnedData.getReturnedType().getSimpleClassName())) : ("rus".equals(this.properties.getLanguage()) ? String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442 \u043e\u0442\u0432\u0435\u0442 %s \u0432 \u0442\u043e\u043f\u0438\u043a %s. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0435\u0440\u0435\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f", returnedData.getReturnedType().getSimpleClassName(), returnedData.getReturnedTopicName()) : String.format("Returns the response %s to topic %s. The return value is not intercepted", returnedData.getReturnedType().getSimpleClassName(), returnedData.getReturnedTopicName())));
        responseAnnotationSpec.addMember("description", "$S", new Object[]{message});
        return responseAnnotationSpec.build();
    }

    private String generateVariableDtoClassName(String methodPropertyValue) {
        return "VariableBy" + methodPropertyValue;
    }

    private String generateSupportDtoClassName(String originalModelName, String methodPropertyValue) {
        return originalModelName + "By" + methodPropertyValue;
    }

    private String qualifiedClassName(JavaFileMetadata javaFileMetadata) {
        return javaFileMetadata.getPackageName() + "." + javaFileMetadata.getClassName();
    }

    private String snakeToCamelCase(String snakeString) {
        Object camelString = snakeString.toLowerCase(Locale.ROOT);
        camelString = ((String)camelString).substring(0, 1).toUpperCase() + ((String)camelString).substring(1);
        while (((String)camelString).contains("_")) {
            camelString = ((String)camelString).replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(((String)camelString).charAt(((String)camelString).indexOf("_") + 1))));
        }
        return camelString;
    }

    public KafkaControllerCodeGenerator(Filer filer, AxenAPIProperties properties) {
        this.filer = filer;
        this.properties = properties;
    }
}

