/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import pro.axenix_innovation.axenapi.consts.Constants;
import pro.axenix_innovation.axenapi.consts.Headers;
import pro.axenix_innovation.axenapi.model.TokenInfo;
import pro.axenix_innovation.axenapi.service.TokenProducerService;
import pro.axenix_innovation.axenapi.utils.KafkaHeaderAccessor;

public class TokenProducerServiceImpl
implements TokenProducerService {
    ConcurrentMap<UUID, TokenInfo> tokens = new ConcurrentHashMap<UUID, TokenInfo>();

    @Override
    public void readTokenFromParams(Map<String, Object> params, UUID messageId) {
        TokenInfo tokenInfo = new TokenInfo(KafkaHeaderAccessor.fromStringHeader(params, Headers.ACCESS_TOKEN), KafkaHeaderAccessor.fromStringHeader(params, Headers.SERVICE_ACCESS_TOKEN));
        this.tokens.put(messageId, tokenInfo);
    }

    @Override
    public Map<String, Object> replaceTokenIntoParams(Map<String, Object> params, UUID messageId) {
        TokenInfo tokenInfo = this.tokens.getOrDefault(messageId, null);
        if (tokenInfo == null) {
            return params;
        }
        String userToken = tokenInfo.getUserToken();
        String serviceToken = tokenInfo.getServiceToken();
        HashMap<String, Object> resultParams = new HashMap<String, Object>(params);
        if (resultParams.containsKey(Constants.USER_TOKEN_KEY)) {
            if (userToken == null) {
                resultParams.remove(Constants.USER_TOKEN_KEY);
            } else {
                resultParams.replace(Constants.USER_TOKEN_KEY, userToken.getBytes());
            }
        } else if (userToken != null) {
            resultParams.put(Constants.USER_TOKEN_KEY, userToken.getBytes());
        }
        if (resultParams.containsKey(Constants.SERVICE_TOKEN_KEY)) {
            if (serviceToken == null) {
                resultParams.remove(Constants.SERVICE_TOKEN_KEY);
            } else {
                resultParams.replace(Constants.SERVICE_TOKEN_KEY, serviceToken.getBytes());
            }
        } else if (serviceToken != null) {
            resultParams.put(Constants.SERVICE_TOKEN_KEY, serviceToken.getBytes());
        }
        this.tokens.remove(messageId);
        return Collections.unmodifiableMap(resultParams);
    }
}

