/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import pro.axenix_innovation.axenapi.service.ResponseHeaderExtractorService;
import pro.axenix_innovation.axenapi.service.impl.HeaderType;
import pro.axenix_innovation.axenapi.utils.KafkaHeaderAccessor;
import pro.axenix_innovation.axenapi.utils.KafkaHelper;

public class ResponseHeaderExtractorServiceImpl
implements ResponseHeaderExtractorService {
    private final Map<String, HeaderType> kafkaHeaders = new HashMap<String, HeaderType>();

    public void appendHeader(String kafkaHeader, HeaderType headerType) {
        this.kafkaHeaders.put(kafkaHeader, headerType);
    }

    @Override
    public Map<String, String> extractHeaders(KafkaHeaderAccessor headerAccessor) {
        return headerAccessor.toMap().entrySet().stream().filter(entry -> this.kafkaHeaders.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            byte[] value = (byte[])entry.getValue();
            switch (this.kafkaHeaders.get(entry.getKey())) {
                case UUID_TYPE: {
                    return KafkaHelper.bytesToUUID(value).toString();
                }
                case STRING_TYPE: {
                    return new String(value);
                }
                case INTEGER_TYPE: {
                    return KafkaHelper.bytesToInt(value).toString();
                }
            }
            return new String(value);
        }));
    }
}

