/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.service.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.support.KafkaHeaders;
import org.springframework.util.CollectionUtils;
import pro.axenix_innovation.axenapi.consts.Headers;
import pro.axenix_innovation.axenapi.service.HeaderAccessorService;
import pro.axenix_innovation.axenapi.service.TokenProducerService;
import pro.axenix_innovation.axenapi.utils.KafkaHeaderAccessor;
import pro.axenix_innovation.axenapi.utils.KafkaHelper;

public class HeaderAccessorServiceImpl
implements HeaderAccessorService {
    private static final Logger log = LoggerFactory.getLogger(HeaderAccessorServiceImpl.class);
    private final Map<String, String> mainHeaderNames = new HashMap<String, String>();
    private final Map<String, String> kafkaHeaderNames;
    private final Map<String, String> uuidHeaderNames = new HashMap<String, String>();
    private final Map<String, String> intHeaderNames = new HashMap<String, String>();
    private final TokenProducerService tokenProducerService;

    public HeaderAccessorServiceImpl(TokenProducerService tokenProducerService) {
        List fields = Arrays.stream(KafkaHeaders.class.getDeclaredFields()).collect(Collectors.toList());
        List names = fields.stream().map(f -> HeaderAccessorServiceImpl.getFieldStringValue(KafkaHeaders.class, f).map(Object::toString).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        List namesDistinct = names.stream().distinct().collect(Collectors.toList());
        this.kafkaHeaderNames = namesDistinct.stream().collect(Collectors.toMap(s -> s, Function.identity()));
        HashSet<String> uuidHeaderNameSet = new HashSet<String>(Arrays.asList(Headers.MESSAGE_GROUP_ID.name(), Headers.MESSAGE_ID.name(), Headers.CORRELATION_ID.name(), Headers.CHAIN_ID.name(), Headers.ID_CHUNKS_MESSAGE.name()));
        HashSet<String> intHeaderNameSet = new HashSet<String>(Arrays.asList(Headers.PROCESSING_RESULT.name(), Headers.CHUNK_NUMBER.name(), Headers.CHUNK_COUNT.name()));
        Arrays.stream(Headers.values()).filter(e -> !uuidHeaderNameSet.contains(e.name()) && !intHeaderNameSet.contains(e.name())).forEach(key -> this.executeOnManyVariants(key.name(), k -> this.mainHeaderNames.put((String)k, (String)k)));
        uuidHeaderNameSet.forEach(key -> this.executeOnManyVariants((String)key, k -> this.uuidHeaderNames.put((String)k, (String)k)));
        intHeaderNameSet.forEach(key -> this.executeOnManyVariants((String)key, k -> this.intHeaderNames.put((String)k, (String)k)));
        this.tokenProducerService = tokenProducerService;
    }

    private void executeOnManyVariants(String str, Consumer<String> consumer) {
        Arrays.asList(str, HeaderAccessorServiceImpl.toCamelCase(str, "_"), HeaderAccessorServiceImpl.toCamelCase(str, "-")).forEach(consumer);
    }

    private static Optional<Object> getFieldStringValue(Object target, Field field) {
        try {
            field.setAccessible(true);
            return Optional.ofNullable(field.get(target));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Optional.empty();
        }
    }

    private static String toCamelCase(String str, String delimiter) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] split = (str = str.toLowerCase()).split(delimiter);
        if (split.length < 2) {
            return str;
        }
        StringBuilder result = new StringBuilder(split[0]);
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            if (s.isEmpty()) continue;
            StringBuilder b = new StringBuilder(s);
            b.replace(0, 1, b.substring(0, 1).toUpperCase());
            result.append((CharSequence)b);
        }
        return result.toString();
    }

    @Override
    public KafkaHeaderAccessor getHeaderAccessor(String topicName, Map<String, String> params) {
        KafkaHeaderAccessor headerAccessor = this.paramsConvertToAccessors(params);
        if (headerAccessor.messageId() == null) {
            headerAccessor.messageId(UUID.randomUUID());
        }
        if (headerAccessor.messageGroupId() == null) {
            headerAccessor.messageGroupId(UUID.randomUUID());
        }
        if (headerAccessor.correlationId() == null) {
            headerAccessor.correlationId(UUID.randomUUID());
        }
        if (headerAccessor.sourceInstanceId() == null) {
            headerAccessor.sourceInstanceId("axenapi");
        }
        if (headerAccessor.traceId() == null) {
            headerAccessor.traceId(UUID.randomUUID());
        }
        headerAccessor.topic(topicName);
        this.tokenProducerService.readTokenFromParams(headerAccessor.toMap(), headerAccessor.messageId());
        return headerAccessor;
    }

    private KafkaHeaderAccessor paramsConvertToAccessors(Map<String, String> params) {
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        params.forEach((key, value) -> {
            if (this.uuidHeaderNames.containsKey(key)) {
                headersMap.put(this.uuidHeaderNames.get(key), KafkaHelper.uuidToBytes(UUID.fromString(value)));
            } else if (this.intHeaderNames.containsKey(key)) {
                headersMap.put(this.uuidHeaderNames.get(key), KafkaHelper.intToBytes(Integer.parseInt(value)));
            } else {
                String result = this.mainHeaderNames.get(key);
                if (result == null) {
                    this.executeOnManyVariants((String)key, k -> {
                        if (this.kafkaHeaderNames.containsKey("kafka_" + k)) {
                            headersMap.put(this.kafkaHeaderNames.get("kafka_" + k), value.getBytes());
                        }
                    });
                } else {
                    headersMap.put(result, value.getBytes());
                }
            }
        });
        return CollectionUtils.isEmpty(headersMap) ? KafkaHeaderAccessor.create() : KafkaHeaderAccessor.ofMap(headersMap);
    }
}

