/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.service.impl;

import jakarta.jms.JMSException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import pro.axenix_innovation.axenapi.jms.JmsMessagePostProcessor;
import pro.axenix_innovation.axenapi.jms.JmsTemplateRegistry;
import pro.axenix_innovation.axenapi.service.JmsSenderService;

public class DefaultJmsSenderService
implements JmsSenderService {
    private static final Logger log = LoggerFactory.getLogger(DefaultJmsSenderService.class);
    private final JmsTemplateRegistry registry;
    @Autowired(required=false)
    protected List<JmsMessagePostProcessor> postProcessors = new ArrayList<JmsMessagePostProcessor>();

    @Override
    public void send(String jmsTemplateName, Object payload, String destination, Map<String, String> params) {
        log.info("send to connection {}", (Object)jmsTemplateName);
        log.info("destination: {}", (Object)destination);
        log.info("payload: {}", payload);
        log.info("params:");
        params.forEach((key, value) -> log.debug("key: {} value: {}", key, value));
        JmsTemplate template = this.registry.receive(jmsTemplateName).orElseThrow(() -> new IllegalStateException("JmsTemplate " + jmsTemplateName + " not find"));
        template.convertAndSend(destination, payload, m -> {
            params.forEach((k, v) -> {
                try {
                    m.setObjectProperty(k, v);
                }
                catch (JMSException jmsException) {
                    log.error("Can not put parameter for message.", (Throwable)jmsException);
                }
            });
            this.postProcessors.forEach(p -> p.process(m));
            return m;
        });
    }

    public DefaultJmsSenderService(JmsTemplateRegistry registry) {
        this.registry = registry;
    }
}

