/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.util.CollectionUtils;
import pro.axenix_innovation.axenapi.annotation.KafkaHandlerDescription;
import pro.axenix_innovation.axenapi.annotation.KafkaHandlerHeaders;
import pro.axenix_innovation.axenapi.annotation.KafkaHandlerRemoteMethod;
import pro.axenix_innovation.axenapi.annotation.KafkaHandlerResponse;
import pro.axenix_innovation.axenapi.annotation.KafkaHandlerTags;
import pro.axenix_innovation.axenapi.annotation.KafkaSecured;
import pro.axenix_innovation.axenapi.annotation.RemoteMethod;
import pro.axenix_innovation.axenapi.annotation.RemoteMethodVariable;
import pro.axenix_innovation.axenapi.code.generator.KafkaControllerCodeGenerator;
import pro.axenix_innovation.axenapi.model.ClassData;
import pro.axenix_innovation.axenapi.model.ParamsData;
import pro.axenix_innovation.axenapi.model.ReturnedData;
import pro.axenix_innovation.axenapi.model.VariableData;
import pro.axenix_innovation.axenapi.model.kafka.KafkaHandlerData;
import pro.axenix_innovation.axenapi.model.kafka.KafkaListenerData;
import pro.axenix_innovation.axenapi.model.kafka.remote.HandlerRemoteMethodMetadata;
import pro.axenix_innovation.axenapi.model.kafka.remote.RemoteMethodMetadata;
import pro.axenix_innovation.axenapi.model.kafka.remote.RemoteMethodVariableMetadata;
import pro.axenix_innovation.axenapi.utils.AxenAPIProperties;
import pro.axenix_innovation.axenapi.utils.ElementHelper;

@SupportedAnnotationTypes(value={"org.springframework.kafka.annotation.KafkaListener"})
public class KafkaControllerProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(KafkaControllerProcessor.class);
    private Messager messager;
    private KafkaControllerCodeGenerator codeGenerator;
    private ElementHelper helper;
    private AxenAPIProperties properties;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.helper = new ElementHelper(processingEnv);
        this.properties = new AxenAPIProperties(processingEnv.getFiler());
        this.codeGenerator = new KafkaControllerCodeGenerator(processingEnv.getFiler(), this.properties);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            TypeElement kafkaListenerAnnotationElement = annotations.stream().findFirst().orElse(null);
            if (kafkaListenerAnnotationElement == null) {
                return false;
            }
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(kafkaListenerAnnotationElement);
            ArrayList<KafkaListenerData> listeners = new ArrayList<KafkaListenerData>();
            for (Element element2 : annotatedElements) {
                if (Objects.equals((Object)element2.getKind(), (Object)ElementKind.METHOD)) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Annotation KafkaListener does not support methods", element2);
                    continue;
                }
                if (!Objects.equals((Object)element2.getKind(), (Object)ElementKind.CLASS)) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Annotation KafkaListener does not support this statement: " + element2.getKind().name(), element2);
                    continue;
                }
                String packageName = this.properties.getPackageName();
                if (packageName != null && !packageName.isBlank() && !element2.asType().toString().startsWith(packageName)) continue;
                List<String> topics = Arrays.asList(element2.getAnnotation(KafkaListener.class).topics());
                if (topics.isEmpty()) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Annotation KafkaListener does not contains topics: ", element2);
                    continue;
                }
                List<KafkaHandlerData> methods = this.processingEnv.getElementUtils().getAllMembers((TypeElement)element2).stream().filter(element -> Objects.equals((Object)element.getKind(), (Object)ElementKind.METHOD)).filter(element -> {
                    List<? extends AnnotationMirror> list = this.processingEnv.getElementUtils().getAllAnnotationMirrors((Element)element);
                    boolean isHandler = false;
                    for (AnnotationMirror annotationMirror : list) {
                        log.debug(annotationMirror.toString());
                        isHandler = this.checkAnnotationName(annotationMirror.toString());
                        if (!isHandler) continue;
                        break;
                    }
                    return isHandler;
                }).map(ExecutableElement.class::cast).filter(this.helper::existsDtoInParameters).map(this::handlerDataByMethod).collect(Collectors.toList());
                System.out.printf("Methods generated for kafka: %s\n", methods);
                String groupId = element2.getAnnotation(KafkaListener.class).groupId();
                listeners.add(KafkaListenerData.builder().listenerClassName(element2.getSimpleName().toString()).topics(topics).handlers(methods).groupId(groupId).build());
            }
            this.codeGenerator.writeFile(listeners);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean checkAnnotationName(String annotation) {
        boolean contains = annotation.contains(this.properties.getAnnotationName());
        if (this.properties.isUseKafkaHandlerAnnotation()) {
            return contains || annotation.contains("org.springframework.kafka.annotation.KafkaHandler");
        }
        return contains;
    }

    private KafkaHandlerData handlerDataByMethod(ExecutableElement method) {
        HandlerRemoteMethodMetadata remoteMethodMetadata = this.extractHandlerRemoteMethodMetadata(method);
        ArrayList<String> requiredFields = new ArrayList<String>();
        if (remoteMethodMetadata != null) {
            if (remoteMethodMetadata.getMethodPropertyName() != null) {
                requiredFields.add(remoteMethodMetadata.getMethodPropertyName());
            }
            if (remoteMethodMetadata.getVariablesPropertyName() != null) {
                requiredFields.add(remoteMethodMetadata.getVariablesPropertyName());
            }
        }
        VariableData variableData = this.variableDataByMethod(method, requiredFields);
        return KafkaHandlerData.builder().secured(this.isSecured(method) != null).securityScheme(this.isSecured(method)).description(this.descriptionByMethod(method)).variableData(variableData).returnedData(this.returnedDataByMethod(method)).params(this.paramsDataByMethod(method)).handlerRemoteMethod(remoteMethodMetadata).tags(this.tagsByMethod(method)).build();
    }

    private String descriptionByMethod(ExecutableElement method) {
        KafkaHandlerDescription handlerDescription = method.getAnnotation(KafkaHandlerDescription.class);
        if (handlerDescription == null) {
            return "";
        }
        return handlerDescription.value();
    }

    private List<String> tagsByMethod(ExecutableElement method) {
        KafkaHandlerTags handlerTags = method.getAnnotation(KafkaHandlerTags.class);
        if (handlerTags == null || handlerTags.tags() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(handlerTags.tags());
    }

    private VariableData variableDataByMethod(ExecutableElement method, List<String> requiredFields) {
        VariableElement variableElement = this.helper.getPayloadVariableElement(method);
        TypeMirror typeMirror = variableElement.asType();
        for (String requiredProperty : requiredFields) {
            if (this.helper.checkMirrorTypeContainsField(typeMirror, requiredProperty)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Payload does not contain required property %s!", requiredProperty), method);
        }
        return VariableData.builder().variableType(this.classDataByTypeMirror(typeMirror)).variableName(variableElement.getSimpleName().toString()).build();
    }

    private ReturnedData returnedDataByMethod(ExecutableElement method) {
        String replyTopic = "";
        TypeMirror returnedTypeMirror = this.helper.getAnnotationValue(this.helper.getAnnotationMirrorByAnnotation(method, KafkaHandlerResponse.class), "payload");
        if (returnedTypeMirror == null) {
            returnedTypeMirror = this.helper.getReturnedTypeMirror(method);
        } else {
            KafkaHandlerResponse annotation = method.getAnnotation(KafkaHandlerResponse.class);
            replyTopic = annotation.replayTopic();
        }
        if (returnedTypeMirror == null || returnedTypeMirror.toString().equals("java.lang.Void")) {
            return null;
        }
        return ReturnedData.builder().returnedType(this.classDataByTypeMirror(returnedTypeMirror)).returnedTopicName(replyTopic).build();
    }

    private List<ParamsData> paramsDataByMethod(ExecutableElement method) {
        KafkaHandlerHeaders headersAnnotation = method.getAnnotation(KafkaHandlerHeaders.class);
        List<ParamsData> params = headersAnnotation == null ? Collections.emptyList() : Arrays.stream(headersAnnotation.headers()).map(kafkaHandlerHeader -> new ParamsData(kafkaHandlerHeader.header(), kafkaHandlerHeader.required())).collect(Collectors.toList());
        return params;
    }

    private HandlerRemoteMethodMetadata extractHandlerRemoteMethodMetadata(ExecutableElement method) {
        TypeMirror typeMirror;
        String variablesPropertyName;
        AnnotationMirror methodsAnnotationMirror = method.getAnnotationMirrors().stream().filter(annotationMirror -> this.isSameType((AnnotationMirror)annotationMirror, (Class<?>)KafkaHandlerRemoteMethod.class)).findFirst().orElse(null);
        if (Objects.isNull(methodsAnnotationMirror)) {
            return null;
        }
        String methodPropertyName = this.helper.findAnnotationValue(String.class, methodsAnnotationMirror, "methodPropertyName");
        if (StringUtils.isBlank((CharSequence)methodPropertyName) || methodPropertyName.contains(" ")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Remote method property name must not be null, empty or contain whitespaces!", method, methodsAnnotationMirror);
        }
        if (StringUtils.isBlank((CharSequence)(variablesPropertyName = this.helper.findAnnotationValue(String.class, methodsAnnotationMirror, "variablesPropertyName"))) || variablesPropertyName.contains(" ")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Remote method variables property name must not be null, empty or contain whitespaces!", method, methodsAnnotationMirror);
        }
        if ((typeMirror = this.helper.findAnnotationValue(TypeMirror.class, methodsAnnotationMirror, "methodPropertyType")) != null && !this.helper.isStringOrEnumTypeMirror(typeMirror)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Remote method property type must be either java.lang.String or enumeration!", method, methodsAnnotationMirror);
        }
        ClassData methodPropertyType = this.classDataByTypeMirror(typeMirror);
        List<AnnotationMirror> methodAnnotations = this.helper.findListAnnotationValue(AnnotationMirror.class, methodsAnnotationMirror, "methods");
        List<RemoteMethodMetadata> remoteMethodMetadataList = methodAnnotations.stream().filter(annotationMirror -> this.isSameType((AnnotationMirror)annotationMirror, (Class<?>)RemoteMethod.class)).map(annotationMirror -> {
            RemoteMethodMetadata remoteMethodMetadata = this.extractRemoteMethodMetadata((AnnotationMirror)annotationMirror);
            if (CollectionUtils.isEmpty(remoteMethodMetadata.getVariables()) && Objects.isNull(remoteMethodMetadata.getVariablesType())) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Remote method variables are not declared", method, (AnnotationMirror)annotationMirror);
                return null;
            }
            if (methodPropertyType != null && !this.helper.enumElementExists(typeMirror, remoteMethodMetadata.getPropertyValue())) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Remote method property value %s does not exists in enumeration %s", remoteMethodMetadata.getPropertyValue(), methodPropertyType.getQualifiedClassName()), method, (AnnotationMirror)annotationMirror);
            }
            return remoteMethodMetadata;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (remoteMethodMetadataList.isEmpty()) {
            return null;
        }
        return HandlerRemoteMethodMetadata.builder().methodPropertyName(methodPropertyName).methodPropertyType(methodPropertyType).variablesPropertyName(variablesPropertyName).methods(remoteMethodMetadataList).build();
    }

    private String isSecured(ExecutableElement method) {
        KafkaSecured annotation = method.getAnnotation(KafkaSecured.class);
        if (annotation == null) {
            return null;
        }
        return annotation.name();
    }

    private RemoteMethodMetadata extractRemoteMethodMetadata(AnnotationMirror methodAnnotationMirror) {
        String description = this.helper.findAnnotationValue(String.class, methodAnnotationMirror, "description");
        String propertyValue = this.helper.findAnnotationValue(String.class, methodAnnotationMirror, "propertyValue");
        List<String> tags = this.helper.findListAnnotationValue(String.class, methodAnnotationMirror, "tags");
        List<AnnotationMirror> methodAnnotations = this.helper.findListAnnotationValue(AnnotationMirror.class, methodAnnotationMirror, "variables");
        List<RemoteMethodVariableMetadata> remoteMethodVariableMetadataList = methodAnnotations.stream().filter(annotationMirror -> this.isSameType((AnnotationMirror)annotationMirror, (Class<?>)RemoteMethodVariable.class)).map(this::extractRemoteMethodVariableMetadata).collect(Collectors.toList());
        TypeMirror typeMirror = this.helper.findAnnotationValue(TypeMirror.class, methodAnnotationMirror, "variablesType");
        return RemoteMethodMetadata.builder().description(description).propertyValue(propertyValue).variables(remoteMethodVariableMetadataList).variablesType(this.classDataByTypeMirror(typeMirror)).tags(tags).build();
    }

    private RemoteMethodVariableMetadata extractRemoteMethodVariableMetadata(AnnotationMirror methodAnnotationMirror) {
        String propertyFieldName = this.helper.findAnnotationValue(String.class, methodAnnotationMirror, "propertyFieldName");
        String description = this.helper.findAnnotationValue(String.class, methodAnnotationMirror, "description");
        TypeMirror typeMirror = this.helper.findAnnotationValue(TypeMirror.class, methodAnnotationMirror, "type");
        return RemoteMethodVariableMetadata.builder().description(description).propertyFieldName(propertyFieldName).type(this.classDataByTypeMirror(typeMirror)).build();
    }

    private ClassData classDataByTypeMirror(TypeMirror typeMirror) {
        if (Objects.isNull(typeMirror)) {
            return null;
        }
        String simpleClassName = this.helper.getClassNameByTypeMirror(typeMirror);
        String packageName = this.helper.getPackageNameByTypeMirror(typeMirror);
        String qualifiedClassName = this.helper.getQualifiedClassNameByTypeMirror(typeMirror);
        return ClassData.builder().simpleClassName(simpleClassName).packageName(packageName).qualifiedClassName(qualifiedClassName).isArray(this.helper.isArrayTypeMirror(typeMirror)).build();
    }

    private boolean isSameType(AnnotationMirror annotationMirror, Class<?> clazz) {
        return this.isSameType(annotationMirror.getAnnotationType(), clazz);
    }

    private boolean isSameType(TypeMirror typeMirror, Class<?> clazz) {
        return this.processingEnv.getTypeUtils().isSameType(typeMirror, this.processingEnv.getElementUtils().getTypeElement(clazz.getName()).asType());
    }
}

