/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.configuration;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.KafkaTemplate;
import pro.axenix_innovation.axenapi.configuration.KafkaProducerConfig;
import pro.axenix_innovation.axenapi.service.KafkaClient4AxenAPI;
import pro.axenix_innovation.axenapi.service.impl.KafkaClient4AxenAPIImpl;

@ConditionalOnProperty(prefix="axenapi.kafka.swagger", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={KafkaProducerConfig.class})
public class KafkaClientConfig {
    private final KafkaTemplate<String, Object> kafkaTemplate;

    public KafkaClientConfig(KafkaTemplate<String, Object> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaClient4AxenAPI kafkaClient4AxenAPI() {
        return new KafkaClient4AxenAPIImpl(this.kafkaTemplate);
    }
}

