/*
 * Decompiled with CFR 0.152.
 */
package pro.axenix_innovation.axenapi.code.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.axenix_innovation.axenapi.model.jms.JmsHandlerMetadata;
import pro.axenix_innovation.axenapi.model.jms.PropertyMetadata;
import pro.axenix_innovation.axenapi.service.JmsSenderService;

public class JmsControllerCodeGenerator {
    private final Filer filer;
    private static final String DESTINATION = "{:DESTINATION}";
    private static final String PAYLOAD_KEY = "{:PAYLOAD_KEY}";
    private static final String SEND_FUNCTION_NAME = "send{:PAYLOAD_KEY}";
    private static final String SEND_PATH = "/send/{:DESTINATION}/{:PAYLOAD_KEY}";
    private static final String JMS_SENDER_OBJECT = "jmsService";
    private static final String PROPERTY_RESOLVER_OBJECT = "propertyResolver";

    public void writeFile(List<JmsHandlerMetadata> handlers) throws Exception {
        FieldSpec serviceFiledSpec = FieldSpec.builder(JmsSenderService.class, (String)JMS_SENDER_OBJECT, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        FieldSpec propertyResolverSpec = FieldSpec.builder(PropertyResolver.class, (String)PROPERTY_RESOLVER_OBJECT, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        MethodSpec constructorMethodSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JmsSenderService.class, JMS_SENDER_OBJECT, new Modifier[0]).addParameter(PropertyResolver.class, PROPERTY_RESOLVER_OBJECT, new Modifier[0]).addStatement("this.$N = $N", new Object[]{JMS_SENDER_OBJECT, JMS_SENDER_OBJECT}).addStatement("this.$N = $N", new Object[]{PROPERTY_RESOLVER_OBJECT, PROPERTY_RESOLVER_OBJECT}).build();
        AnnotationSpec requestMappingSpec = AnnotationSpec.builder(RequestMapping.class).addMember("path", "$S", new Object[]{"/jms"}).build();
        AnnotationSpec conditionalOnPropertySpec = AnnotationSpec.builder(ConditionalOnProperty.class).addMember("prefix", "$S", new Object[]{"swagger4kafka"}).addMember("name", "$S", new Object[]{"enabled"}).addMember("havingValue", "$S", new Object[]{"true"}).build();
        System.out.println("Methods generated for jms =========================");
        handlers.forEach(h -> System.out.printf("JmsTemplateName: %s,\npayload: %s,\ndestination: %s,\ndescription,\nproperties: %s\n", h.getJmsTemplateName(), h.getPayload(), h.getDestination(), h.getDescription(), h.getProperties()));
        System.out.println("=====================================================");
        TypeSpec controllerTypeSpec = TypeSpec.classBuilder((String)"JmsController").addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(serviceFiledSpec).addField(propertyResolverSpec).addMethod(constructorMethodSpec).addMethods(this.methods(handlers)).addAnnotation(RestController.class).addAnnotation(requestMappingSpec).addAnnotation(conditionalOnPropertySpec).build();
        JavaFile javaFile = JavaFile.builder((String)"pro.axenix_innovation.axenapi.controller", (TypeSpec)controllerTypeSpec).indent("    ").build();
        JavaFileObject builderFile = this.filer.createSourceFile("pro.axenix_innovation.axenapi.controller.JmsController", new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            javaFile.writeTo((Appendable)out);
        }
    }

    private List<MethodSpec> methods(List<JmsHandlerMetadata> handlers) {
        return handlers.stream().map(this::methodByHandler).collect(Collectors.toList());
    }

    private MethodSpec methodByHandler(JmsHandlerMetadata handler) {
        String functionName = this.functionNameByChannelType(handler);
        String path = this.pathByChannelType(handler);
        ArrayList<AnnotationSpec> methodAnnotations = new ArrayList<AnnotationSpec>();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(PostMapping.class).addMember("path", "$S", new Object[]{path}).build();
        methodAnnotations.add(annotationSpec);
        AnnotationSpec.Builder operationAnnotationBuilder = AnnotationSpec.builder(Operation.class).addMember("description", "$S", new Object[]{handler.getDescription()});
        if (!handler.getProperties().isEmpty()) {
            List<AnnotationSpec> apiImplicitParam = this.annotationsByProperties(handler.getProperties());
            apiImplicitParam.forEach(propertyAnnotation -> operationAnnotationBuilder.addMember("parameters", "$L", new Object[]{propertyAnnotation}));
        }
        methodAnnotations.add(operationAnnotationBuilder.build());
        ParameterSpec payloadParameter = ParameterSpec.builder((TypeName)ClassName.get((String)handler.getPayload().getPackageName(), (String)handler.getPayload().getSimpleClassName(), (String[])new String[0]), (String)"payload", (Modifier[])new Modifier[0]).addAnnotation(RequestBody.class).build();
        AnnotationSpec.Builder hiddenBuilder = AnnotationSpec.builder(Parameter.class).addMember("hidden", "$L", new Object[]{true});
        ParameterSpec paramsParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), (String)"params", (Modifier[])new Modifier[0]).addAnnotation(RequestParam.class).addAnnotation(hiddenBuilder.build()).build();
        String sendToBlock = "$N.send(jmsTemplateName, payload, targetName, params)";
        String channelName = this.replaceSymbols(handler.getDestination());
        String jmsTemplateName = this.replaceSymbols(handler.getJmsTemplateName());
        CodeBlock codeBlock = CodeBlock.builder().addStatement("final $T jmsTemplateName = $N.getProperty($S, $S)", new Object[]{String.class, PROPERTY_RESOLVER_OBJECT, jmsTemplateName, jmsTemplateName}).addStatement("final String targetName = $N.getProperty($S, $S)", new Object[]{PROPERTY_RESOLVER_OBJECT, channelName, channelName}).addStatement("$N.send(jmsTemplateName, payload, targetName, params)", new Object[]{JMS_SENDER_OBJECT}).build();
        return MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(methodAnnotations).addParameter(payloadParameter).addParameter(paramsParameter).addCode(codeBlock).build();
    }

    private String functionNameByChannelType(JmsHandlerMetadata handler) {
        return SEND_FUNCTION_NAME.replace(PAYLOAD_KEY, handler.getPayload().getSimpleClassName());
    }

    private String pathByChannelType(JmsHandlerMetadata handler) {
        return SEND_PATH.replace(DESTINATION, handler.getDestination()).replace(PAYLOAD_KEY, handler.getPayload().getSimpleClassName());
    }

    private List<AnnotationSpec> annotationsByProperties(List<PropertyMetadata> properties) {
        return properties.stream().map(property -> AnnotationSpec.builder(Parameter.class).addMember("name", "$S", new Object[]{property.getName()}).addMember("in", "$L", new Object[]{"io.swagger.v3.oas.annotations.enums.ParameterIn.QUERY"}).addMember("required", "$L", new Object[]{property.getRequired()}).build()).collect(Collectors.toList());
    }

    private String replaceSymbols(String value) {
        return value.replace("$", "").replace("{", "").replace("}", "");
    }

    public JmsControllerCodeGenerator(Filer filer) {
        this.filer = filer;
    }
}

