/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="audit")
public class AuditMojo
extends AbstractMojo {
    @Parameter(defaultValue="false", property="includeGroupId")
    boolean includeGroupId;
    @Inject
    MavenSession mavenSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Parent parent;
        MavenProject prj = this.mavenSession.getCurrentProject();
        Model m = prj.getOriginalModel();
        if (!this.versionPropExpr(m).equals(m.getVersion())) {
            this.logError(prj.getArtifactId() + ": prj.version: " + m.getVersion() + " : " + m.getLocation((Object)"version"));
        }
        if ((parent = m.getParent()) != null && !this.versionPropExpr(parent).equals(parent.getVersion())) {
            this.logError(prj.getArtifactId() + ": prj.parent.version: " + parent.getVersion() + " : " + parent.getLocation((Object)"version"));
        }
        for (Dependency d : m.getDependencies()) {
            this.getLog().info((CharSequence)("[HASHVER] " + d.getArtifactId() + ":" + d.getVersion() + ":" + d.getLocation((Object)d.getArtifactId())));
        }
    }

    void logError(String msg) {
        this.getLog().error((CharSequence)("[HASHVER] " + msg));
    }

    String versionPropExpr(Model m) {
        return "${" + this.versionProp(m) + "}";
    }

    String versionProp(Model m) {
        return this.includeGroupId ? m.getGroupId() + "." + m.getArtifactId() + ".version" : m.getArtifactId() + ".version";
    }

    String versionPropExpr(Parent p) {
        return "${" + this.versionProp(p) + "}";
    }

    String versionProp(Parent p) {
        return this.includeGroupId ? p.getGroupId() + "." + p.getArtifactId() + ".version" : p.getArtifactId() + ".version";
    }
}

