/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.storage.Storage;
import aot.view.Application;
import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventMixer;
import aot.view.EventSource;
import aot.view.Instance;
import java.util.Iterator;
import java.util.TreeMap;

public class Version
implements Iterable<Instance>,
EventSource {
    protected final Application application;
    protected final String id;
    protected final Storage storage;

    protected Version(Application application, String id) {
        this.application = application;
        this.id = id;
        this.storage = application.getStorage().substorage(String.format("/%s", id));
    }

    public Application getApplication() {
        return this.application;
    }

    public String getId() {
        return this.id;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public TreeMap<String, Instance> getInstances() {
        return this.getInstances(null);
    }

    public TreeMap<String, Instance> getInstances(String filter) {
        TreeMap<String, Instance> instances = new TreeMap<String, Instance>();
        for (String instanceId : this.storage.find("", filter)) {
            Instance instance = new Instance(this, instanceId);
            instances.put(instance.getId(), instance);
        }
        return instances;
    }

    @Override
    public Iterator<Instance> iterator() {
        return this.getInstances().values().iterator();
    }

    @Override
    public Iterable<Event> getEvents(EventFilter filter) {
        return new EventMixer(filter, this.getInstances(filter.getInstance()).values());
    }
}

