/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.util.TimeUtil;
import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventSource;
import aot.view.Layer;
import aot.view.LogFileException;
import java.util.GregorianCalendar;

public class LogFile
implements EventSource {
    protected final Layer layer;
    protected final String id;
    protected final long time;

    protected LogFile(Layer layer, String id) {
        this.layer = layer;
        this.id = id;
        this.time = LogFile.toTime(id);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public String getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public Iterable<Event> getEvents(EventFilter filter) {
        return null;
    }

    private static long toTime(String id) {
        String[] ids = id.split("/");
        int year1 = Integer.parseInt(ids[1]);
        int month1 = Integer.parseInt(ids[2]);
        int day1 = Integer.parseInt(ids[3]);
        int hour1 = Integer.parseInt(ids[4]);
        int minute1 = Integer.parseInt(ids[5]);
        int second1 = Integer.parseInt(ids[6]);
        int millisecond1 = Integer.parseInt(ids[7]);
        String name = ids[8];
        String[] names = name.split(".");
        String n = names[0];
        String e = names[1];
        String[] ns = n.split("-");
        int year2 = Integer.parseInt(ns[0]);
        int month2 = Integer.parseInt(ns[1]);
        int day2 = Integer.parseInt(ns[2]);
        int hour2 = Integer.parseInt(ns[3]);
        int minute2 = Integer.parseInt(ns[4]);
        int second2 = Integer.parseInt(ns[5]);
        int millisecond2 = Integer.parseInt(ns[6]);
        if (year1 == year2 && month1 == month2 && day1 == day2 && hour1 == hour2 && minute1 == minute2 && second1 == second2 && millisecond1 == millisecond2 && e.equals("log")) {
            GregorianCalendar calendar = new GregorianCalendar(TimeUtil.TIMEZONE_UTC);
            calendar.set(1, year1);
            calendar.set(2, month1 - 1);
            calendar.set(5, day1);
            calendar.set(10, hour1);
            calendar.set(12, minute1);
            calendar.set(13, second1);
            calendar.set(14, millisecond1);
            return calendar.getTimeInMillis();
        }
        throw new LogFileException(String.format("Illegal log file id '%s'", id));
    }
}

