/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.storage.Storage;
import aot.util.StringUtil;
import aot.util.TimeUtil;
import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventSource;
import aot.view.EventStream;
import aot.view.Instance;
import aot.view.LogFile;
import java.util.Iterator;
import java.util.TreeMap;

public class Layer
implements Iterable<LogFile>,
EventSource {
    protected final Instance instance;
    protected final String id;
    protected final Storage storage;

    protected Layer(Instance instance, String id) {
        this.instance = instance;
        this.id = id;
        this.storage = instance.getStorage().substorage(String.format("/%s", id));
    }

    public Instance getInstance() {
        return this.instance;
    }

    public String getId() {
        return this.id;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public TreeMap<Long, LogFile> getFiles() {
        TreeMap<Long, LogFile> files = new TreeMap<Long, LogFile>();
        for (String fileId : this.storage.find("")) {
            LogFile file = new LogFile(this, fileId);
            files.put(file.getTime(), file);
        }
        return files;
    }

    public TreeMap<Long, LogFile> getFiles(long beginTime, long endTime) {
        String beginTimePath = TimeUtil.formatPath(beginTime);
        String endTimePath = TimeUtil.formatPath(endTime);
        String timePath = StringUtil.getCommonPrefix(beginTimePath, endTimePath);
        TreeMap<Long, LogFile> files = new TreeMap<Long, LogFile>();
        String path = beginTimePath;
        while (true) {
            LogFile minFile = null;
            for (String fileId : this.storage.find(path)) {
                LogFile file = new LogFile(this, fileId);
                if (file.getTime() >= beginTime || minFile != null && file.getTime() <= minFile.getTime()) continue;
                minFile = file;
            }
            if (minFile != null) {
                files.put(minFile.getTime(), minFile);
                break;
            }
            if (path.isEmpty()) break;
            path = path.substring(0, path.lastIndexOf("/"));
        }
        for (String fileId : this.storage.find(timePath)) {
            LogFile file = new LogFile(this, fileId);
            files.put(file.getTime(), file);
        }
        return files;
    }

    @Override
    public Iterator<LogFile> iterator() {
        return this.getFiles().values().iterator();
    }

    @Override
    public Iterable<Event> getEvents(EventFilter filter) {
        return new EventStream(filter, this.getFiles(filter.getBeginTime(), filter.getEndTime()).values());
    }
}

