/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.storage.Storage;
import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventMixer;
import aot.view.EventSource;
import aot.view.Layer;
import aot.view.Version;
import java.util.Iterator;
import java.util.TreeMap;

public class Instance
implements Iterable<Layer>,
EventSource {
    protected final Version version;
    protected final String id;
    protected final Storage storage;

    protected Instance(Version version, String id) {
        this.version = version;
        this.id = id;
        this.storage = version.getStorage().substorage(String.format("/%s", id));
    }

    public Version getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public TreeMap<String, Layer> getLayers() {
        return this.getLayers(null);
    }

    public TreeMap<String, Layer> getLayers(String filter) {
        TreeMap<String, Layer> layers = new TreeMap<String, Layer>();
        for (String layerId : this.storage.find("", filter)) {
            Layer layer = new Layer(this, layerId);
            layers.put(layer.getId(), layer);
        }
        return layers;
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.getLayers().values().iterator();
    }

    @Override
    public Iterable<Event> getEvents(EventFilter filter) {
        return new EventMixer(filter, this.getLayers(filter.getLayer()).values());
    }
}

