/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventSource;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EventStream
implements Iterable<Event> {
    protected final EventFilter filter;
    protected final Iterable<EventSource> sources;

    public <T extends EventSource> EventStream(EventFilter filter, final Iterable<T> sources) {
        this.filter = filter;
        this.sources = new Iterable<EventSource>(){

            @Override
            public Iterator<EventSource> iterator() {
                return new Iterator<EventSource>(){
                    private final Iterator<T> iterator;
                    {
                        this.iterator = sources.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public EventSource next() {
                        return (EventSource)this.iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public EventFilter getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<Event> iterator() {
        return new Iterator<Event>(){
            private final Iterator<EventSource> sourceIterator;
            private Iterator<Event> eventIterator;
            private Event event;
            {
                this.sourceIterator = EventStream.this.sources.iterator();
                this.eventIterator = this.sourceIterator.hasNext() ? this.sourceIterator.next().getEvents(EventStream.this.filter).iterator() : Collections.emptyIterator();
                this.event = this.findNext();
            }

            private Event findNext() {
                if (this.eventIterator.hasNext()) {
                    return this.eventIterator.next();
                }
                while (this.sourceIterator.hasNext()) {
                    this.eventIterator = this.sourceIterator.next().getEvents(EventStream.this.filter).iterator();
                    if (!this.eventIterator.hasNext()) continue;
                    return this.eventIterator.next();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.event != null;
            }

            @Override
            public Event next() {
                Event ev = this.event;
                if (ev != null) {
                    this.event = this.findNext();
                    return ev;
                }
                throw new NoSuchElementException("Next event is not found");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

