/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventSource;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class EventMixer
implements Iterable<Event> {
    protected final EventFilter filter;
    protected final EventSource[] sources;

    public <T extends EventSource> EventMixer(EventFilter filter, Iterable<T> sources) {
        this.filter = filter;
        this.sources = EventMixer.toArray(sources);
    }

    public EventFilter getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<Event> iterator() {
        final Iterator[] iters = new Iterator[this.sources.length];
        int eventCount = 0;
        Event[] events = new Event[this.sources.length];
        int ci = this.sources.length;
        for (int i = 0; i < ci; ++i) {
            Iterator<Event> iter;
            iters[i] = iter = this.sources[i].getEvents(this.filter).iterator();
            if (iter.hasNext()) {
                ++eventCount;
                events[i] = iter.next();
                continue;
            }
            events[i] = null;
        }
        final Event[] evs = eventCount > 0 ? events : null;
        return new Iterator<Event>(){
            private final Iterator<Event>[] iterators;
            private Event[] events;
            {
                this.iterators = iters;
                this.events = evs;
            }

            @Override
            public boolean hasNext() {
                return this.events != null;
            }

            @Override
            public Event next() {
                int eventCount = 0;
                int min = -1;
                Event minEvent = null;
                int ci = this.events.length;
                for (int i = 0; i < ci; ++i) {
                    Event event = this.events[i];
                    if (event == null) continue;
                    ++eventCount;
                    if (minEvent != null) {
                        if (event.compareTo(minEvent) >= 0) continue;
                        min = i;
                        minEvent = event;
                        continue;
                    }
                    min = i;
                    minEvent = event;
                }
                if (minEvent != null) {
                    Iterator<Event> iterator = this.iterators[min];
                    this.events[min] = iterator.hasNext() ? iterator.next() : null;
                    if (this.events[min] == null && --eventCount == 0) {
                        this.events = null;
                    }
                    return minEvent;
                }
                throw new NoSuchElementException("Next event is not found");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private static <T extends EventSource> EventSource[] toArray(Iterable<T> sources) {
        LinkedList<EventSource> list = new LinkedList<EventSource>();
        for (EventSource source : sources) {
            list.add(source);
        }
        return list.toArray(new EventSource[list.size()]);
    }
}

