/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.storage.Storage;
import aot.view.Application;
import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventMixer;
import aot.view.EventSource;
import java.util.Iterator;
import java.util.TreeMap;

public class Environment
implements Iterable<Application>,
EventSource {
    protected final Storage configStorage;
    protected final Storage dataStorage;

    public Environment(Storage configStorage, Storage dataStorage) {
        this.configStorage = configStorage;
        this.dataStorage = dataStorage;
    }

    public Storage getConfigStorage() {
        return this.configStorage;
    }

    public Storage getDataStorage() {
        return this.dataStorage;
    }

    public TreeMap<String, Application> getApplications() {
        return this.getApplications(null);
    }

    public TreeMap<String, Application> getApplications(String filter) {
        TreeMap<String, Application> applications = new TreeMap<String, Application>();
        for (String applicationId : this.dataStorage.find("", filter)) {
            Application application = new Application(this, applicationId);
            applications.put(application.getId(), application);
        }
        return applications;
    }

    @Override
    public Iterator<Application> iterator() {
        return this.getApplications().values().iterator();
    }

    @Override
    public Iterable<Event> getEvents(EventFilter filter) {
        return new EventMixer(filter, this.getApplications(filter.getApplication()).values());
    }
}

