/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.util.Binariable;
import aot.util.CborUtil;
import aot.util.JsonUtil;
import aot.view.BinaryEvent;
import aot.view.Event;
import aot.view.EventFilter;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;

public class DefaultEventFilter
implements Serializable,
Binariable,
EventFilter {
    private static final long serialVersionUID = 1L;
    public final long begin;
    public final long end;
    public final Pattern logger;
    public final Pattern message;
    public final List<Tag> tags;
    public final Pattern dataType;
    public final int dataLength;

    public DefaultEventFilter(long begin, long end, Pattern logger, Pattern message, List<Tag> tags, Pattern dataType, int dataLength) {
        this.begin = begin;
        this.end = end;
        this.logger = logger;
        this.message = message;
        this.tags = tags;
        this.dataType = dataType;
        this.dataLength = dataLength;
    }

    protected boolean matchesTags(Event event) {
        if (this.tags == null) {
            return true;
        }
        for (Tag tag : this.tags) {
            String value = event.tags.get(tag.key);
            if (value == null || !tag.value.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getApplication() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public String getInstance() {
        return null;
    }

    @Override
    public String getLayer() {
        return null;
    }

    @Override
    public long getBeginTime() {
        return this.begin;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public boolean matchEvent(Event event) {
        if (event.time < this.begin || event.time >= this.end) {
            return false;
        }
        if (this.logger != null && !this.logger.matcher(event.logger).matches()) {
            return false;
        }
        if (this.message != null && !this.message.matcher(event.message).matches()) {
            return false;
        }
        if (!this.matchesTags(event)) {
            return false;
        }
        if (event instanceof BinaryEvent) {
            BinaryEvent dataEvent = (BinaryEvent)event;
            if (this.dataType != null && !this.dataType.matcher(dataEvent.binaryType).matches()) {
                return false;
            }
            if (this.dataLength >= 0 && dataEvent.binaryData.length > this.dataLength) {
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] toBytes() {
        return CborUtil.toBytes(this);
    }

    public String toString() {
        return JsonUtil.toString(this);
    }

    public static DefaultEventFilter valueOf(byte[] bytes) {
        return CborUtil.fromBytes(bytes, DefaultEventFilter.class);
    }

    public static DefaultEventFilter valueOf(String string) {
        return JsonUtil.fromString(string, DefaultEventFilter.class);
    }

    public static class Tag
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String key;
        public final Pattern value;

        public Tag(String key, String value) {
            this(key, Pattern.compile(value));
        }

        public Tag(String key, Pattern value) {
            this.key = key;
            this.value = value;
        }
    }
}

